<?php

namespace App\Http\Controllers\Admin\Reports\DriverHours;

use Carbon\Carbon;
use App\Models\Admin\Driver;
use Illuminate\Http\Request;
use App\Models\Admin\Reservation;
use App\Http\Controllers\Controller;

class DriverHoursController extends Controller
{
    public function index()
    {
        $drivers = Driver::select('id', 'first_name', 'last_name')->orderBy('first_name', 'ASC')->get();
        return view('admin.reports.driver-report.index',[
            'drivers' => $drivers,
        ]);
    }
    public function getFilterData(Request $request)
    {
        $driverId = $request->input('selectedDriverId');
        $fromDate = $request->input('fromDate');
        $toDate = $request->input('toDate');

        $query = Reservation::with('Customer')
        ->whereDate('pick_up_date', '>=', $fromDate)
        ->whereDate('pick_up_date', '<=', $toDate)
        ->where(function($q){
            $q->whereIn('status',['new_reservation','Cancelled'])
            ->orWhere('driver_status',['No Run','No Show','Completed']);
        })
        ->whereNotNull('driver_id');

        if ($driverId !== 'all') {
            $query->where('driver_id',$driverId);
        }

        $reservations = $query->orderBy('pick_up_date', 'ASC')->get();

        return response()->json(["reservations"=>$reservations,"sDate"=> Carbon::today()->toDateString()], 200);

    }
}
