<?php

namespace App\Http\Controllers\Admin\Reports\DriverExpense;

use App\Models\Admin\Driver;
use Illuminate\Http\Request;
use App\Models\Admin\ExpensesHead;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\Admin\ExpenseDetails;

class DriverExpenseReportController extends Controller
{
    public function index()
    {
        $drivers = Driver::select('id', 'user_id','first_name', 'last_name')->orderBy('first_name', 'ASC')->get();
        return view('admin.reports.driver-expense.index',[
            'drivers' => $drivers
        ]);
    }

    public function getGroupedData(Request $request)
    {
        try {
            $driverId = $request->input('selectedDriverId');
            $fromDate = $request->input('fromDate');
            $toDate = $request->input('toDate');
            $expenseDetails = ExpenseDetails::where('user_group_id', '2')
                ->with('driver:id,first_name,last_name,category_id')
                ->select(DB::raw('SUM(amount) as amount'), 'expense_date', 'user_id')
                ->when($driverId,function($subQuery) use ($driverId){
                    if($driverId !== 'all'){
                        return $subQuery->where('user_id',$driverId);
                    }
                })
                ->whereDate('expense_date', '>=', $fromDate)
                ->whereDate('expense_date', '<=', $toDate)
                ->groupBy('user_id','expense_date')
                ->get();
            return response()->json($expenseDetails, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
}
