<?php

namespace App\Http\Controllers\Admin\Reports\Customer;

use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Models\Admin\Customer;
use App\Http\Controllers\Controller;

class CustomerReportController extends Controller
{
    public function phoneIndex()
    {
        return view('admin.reports.customer-details.phone');
    }
    public function emailIndex()
    {
        return view('admin.reports.customer-details.email');
    }

    public function getFilterEmail(Request $request)
    {
        try {

            $customers_data = Customer::select('email', 'first_name', 'last_name','cc_number')
                ->whereIn('customer_type', ['Registered', 'registered'])
                ->whereNotNull('email')
                ->whereBetween('created_at', [
                    Carbon::parse($request->input('fromDate'))->startOfDay(),
                    Carbon::parse($request->input('toDate'))->endOfDay(),
                ])
                ->distinct('email')
                ->get();
            return response()->json($customers_data, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getFilterPhone(Request $request)
    {
        try {
            $customers_data = Customer::select('phone_number', 'mobile_number', 'first_name', 'last_name','cc_number')
                                ->whereIn('customer_type', ['Registered', 'registered'])
                                ->whereBetween('created_at', [
                                    Carbon::parse($request->input('fromDate'))->startOfDay(),
                                    Carbon::parse($request->input('toDate'))->endOfDay(),
                                ])
                                ->get();
            return response()->json($customers_data, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
}
