<?php

namespace App\Http\Controllers\Admin\PayType;

use stdClass;
use Illuminate\Http\Request;
use App\Models\Admin\PayType;
use App\Models\Admin\Reservation;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class PayTypeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.managements.pay-types.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            $pay_type = new PayType();
            $pay_type->user_id = Auth::id();

            $pay_type->name = $request->name;

            $pay_type->save();

            return response()->json(['message' => 'Pay Type save successfully'], 201);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            $obj = new stdClass();

            $pay_type = PayType::findOrFail($id);

            $obj->pay_type = $pay_type;

            return response()->json($obj);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            $pay_type = PayType::findOrFail($id);

            $pay_type->name = $request->name;

            $pay_type->save();

            return response()->json(['message' => 'Pay Type updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    // get data
    public function getData()
    {
        try {
            $data = PayType::select('id', 'name', 'is_active')->where('is_active','1')
                ->orderby('name', 'ASC')->get();

            return response()->json($data, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function updateIsActive(Request $request, $id)
    {
        try {
            PayType::whereId($id)->update([
                'is_active' => $request->status
            ]);

            return response()->json(['message' => 'Pay Type status updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
}
