<?php

namespace App\Http\Controllers\Admin\OtherCharges;

use stdClass;
use Illuminate\Http\Request;
use App\Models\Admin\Services;
use App\Models\Admin\OtherCharges;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Models\Admin\CitiesServicesSettings;
use App\Models\Admin\TimelyAdditionalCharges;

class OtherChargesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        return view('admin.managements.other-charges.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            $other_charges = new OtherCharges();
            $other_charges->user_id = Auth::id();

            $other_charges->name = $request->name;
            $other_charges->operator = $request->operator;
            $other_charges->is_percentage = $request->is_percentage ? $request->is_percentage : false;
            $other_charges->key = preg_replace('/\s+/', '_', $request->name);
            $other_charges->is_active = 1;

            // dd($other_charges);

            $other_charges->save();

            return response()->json(['message' => 'Other Charges save successfully', 'otherCharges' => $other_charges], 201);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            $obj = new stdClass();

            $other_charges = OtherCharges::findOrFail($id);

            $obj->other_charges = $other_charges;

            return response()->json($obj);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            $other_charges = OtherCharges::findOrFail($id);

            $other_charges->name = $request->name;
            $other_charges->operator = $request->operator;

            $other_charges->save();

            return response()->json(['message' => 'Other Charges updated successfully', 'otherCharges' => $other_charges], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        // dd($id);
        try {

            CitiesServicesSettings::select('id', 'city_id', 'service_id', 'services')
                ->chunk(100, function ($cityServiceSettings, $id) {
                    foreach ($cityServiceSettings as $setting) {
                        $services = $setting->services; // Decode JSON to array

                        if (isset($services['services'])) {
                            foreach ($services['services'] as &$service) { // Use reference to modify the original array
                                if (isset($service['millage_service']['additional_millage_charges'])) {
                                    foreach ($service['millage_service']['additional_millage_charges'] as $key => $charges) {

                                        if ((int)$charges['id'] === (int)$id) {
                                            $array_deleted[] = $charges;
                                            unset($service['millage_service']['additional_millage_charges'][$key]);
                                        }
                                    }
                                    // Re-index the array to prevent JSON array gaps
                                    $service['millage_service']['additional_millage_charges'] = array_values($service['millage_service']['additional_millage_charges']);
                                }

                                // Remove from Hourly Service As well
                                if (isset($service['hourly_service']['additional_hourly_charges'])) {
                                    foreach ($service['hourly_service']['additional_hourly_charges'] as $key => $charges) {

                                        if ((int)$charges['id'] === (int)$id) {
                                            $array_deleted[] = $charges;
                                            unset($service['hourly_service']['additional_hourly_charges'][$key]);
                                        }
                                    }
                                    // Re-index the array to prevent JSON array gaps
                                    $service['hourly_service']['additional_hourly_charges'] = array_values($service['hourly_service']['additional_hourly_charges']);
                                }
                            }
                        }

                        // Encode the modified array back to JSON and save it
                        $setting->services = $services;
                        $setting->save();
                    }
                });

            $otherCharges = OtherCharges::findOrFail($id);
            $otherCharges->delete();


            //     $cityServiceSettings = CitiesServicesSettings::select('id', 'city_id', 'service_id', 'services')
            //     ->get();
            //    // dd($id);
            //    $array_deleted = [];
            //     if ($cityServiceSettings) {
            //         foreach ($cityServiceSettings as $cityService) {
            //             $services = $cityService->services; // Decode JSON to array

            //             if (isset($services['services'])) {
            //                 foreach ($services['services'] as &$service) { // Use reference to modify the original array
            //                     if (isset($service['millage_service']['additional_millage_charges'])) {
            //                         foreach ($service['millage_service']['additional_millage_charges'] as $key => $charges) {

            //                             if ((int)$charges['id'] === (int)$id) {
            //                                 $array_deleted[] = $charges;
            //                                 unset($service['millage_service']['additional_millage_charges'][$key]);
            //                             }
            //                         }
            //                         // Re-index the array to prevent JSON array gaps
            //                         $service['millage_service']['additional_millage_charges'] = array_values($service['millage_service']['additional_millage_charges']);
            //                     }

            //                     // Remove from Hourly Service As well
            //                     if (isset($service['hourly_service']['additional_hourly_charges'])) {
            //                         foreach ($service['hourly_service']['additional_hourly_charges'] as $key => $charges) {

            //                             if ((int)$charges['id'] === (int)$id) {
            //                                 $array_deleted[] = $charges;
            //                                 unset($service['hourly_service']['additional_hourly_charges'][$key]);
            //                             }
            //                         }
            //                         // Re-index the array to prevent JSON array gaps
            //                         $service['hourly_service']['additional_hourly_charges'] = array_values($service['hourly_service']['additional_hourly_charges']);
            //                     }
            //                 }
            //             }

            //             // Encode the modified array back to JSON and save it
            //             $cityService->services = $services;
            //             $cityService->save();
            //         }
            //     }

            return response()->json(['message' => 'Other Charges deleted Successfully '], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    // get data
    public function getData()
    {
        try {
            $data = OtherCharges::select('id', 'name', 'operator', 'is_percentage', 'is_active')
                ->orderby('name', 'ASC')->get();

            return response()->json($data, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getFormData()
    {
        try {
            $obj = new stdClass();
            $obj->allOtherCharges = OtherCharges::select('id', 'name')->where('is_active', 1)->get();
            $obj->allTimelyCharges = TimelyAdditionalCharges::select('id', 'time_in', 'time_out')->where('is_active', 1)->get();

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function updateIsActive(Request $request, $id)
    {
        try {
            OtherCharges::whereId($id)->update([
                'is_active' => $request->status
            ]);

            return response()->json(['message' => 'Other Charges status updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function removeCharges($id)
    {
        try {


            $cityServiceSettings = CitiesServicesSettings::select('id', 'city_id', 'service_id', 'services')
                ->get();
            // dd($id);
            $array_deleted = [];
            if ($cityServiceSettings) {
                foreach ($cityServiceSettings as $cityService) {
                    $services = $cityService->services; // Decode JSON to array

                    if (isset($services['services'])) {
                        foreach ($services['services'] as &$service) { // Use reference to modify the original array
                            if (isset($service['millage_service']['additional_millage_charges'])) {
                                foreach ($service['millage_service']['additional_millage_charges'] as $key => $charges) {

                                    if ((int)$charges['id'] === (int)$id) {
                                        $array_deleted[] = $charges;
                                        unset($service['millage_service']['additional_millage_charges'][$key]);
                                    }
                                }
                                // Re-index the array to prevent JSON array gaps
                                $service['millage_service']['additional_millage_charges'] = array_values($service['millage_service']['additional_millage_charges']);
                            }

                            // Remove from Hourly Service As well
                            if (isset($service['hourly_service']['additional_hourly_charges'])) {
                                foreach ($service['hourly_service']['additional_hourly_charges'] as $key => $charges) {

                                    if ((int)$charges['id'] === (int)$id) {
                                        $array_deleted[] = $charges;
                                        unset($service['hourly_service']['additional_hourly_charges'][$key]);
                                    }
                                }
                                // Re-index the array to prevent JSON array gaps
                                $service['hourly_service']['additional_hourly_charges'] = array_values($service['hourly_service']['additional_hourly_charges']);
                            }
                        }
                    }

                    // Encode the modified array back to JSON and save it
                    $cityService->services = $services;
                    $cityService->save();
                }
            }

            // $otherCharges = OtherCharges::findOrFail($id);
            // $otherCharges->delete();



            return response()->json(['message' => 'Successfully deleted'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
}
