<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Models\Admin\HomeSlider;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class HomeSliderController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $homeSliders = HomeSlider::select('id', 'description', 'image')->orderby('description', 'ASC')->get();

        return view('admin.home-sliders.index', [
            'homeSliders' => $homeSliders
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            DB::beginTransaction();

            $home_slider = new HomeSlider();

            $home_slider->user_id = Auth::id();
            $home_slider->description = $request->description;

            $home_slider->save();

            $sliderImage = null;

            if ($request->file('image')) {
                $sliderImage =  $home_slider->id . '_image.' . pathinfo($request->file('image')
                ->getClientOriginalName(), PATHINFO_EXTENSION);
                $request->file('image')->storeAs('home_slider_images', $sliderImage, 'public');
            }

            HomeSlider::where('id', $home_slider->id)->update([
                'image' =>  $sliderImage,
            ]);

            DB::commit();
            return response()->json(['message' => 'Car Type added successfully'], 201);
        } catch (\Exception $exception) {
            DB::rollback();
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\HomeSlider  $homeSlider
     * @return \Illuminate\Http\Response
     */
    public function show(HomeSlider $homeSlider)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\HomeSlider  $homeSlider
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            // home slider
            $home_slider = HomeSlider::whereId($id)->first();

            return response()->json($home_slider, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\HomeSlider  $homeSlider
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            DB::beginTransaction();

            $home_slider = HomeSlider::findOrFail($id);

            $home_slider->description = $request->description;

            $home_slider->save();

            $sliderImage = $request->file('image');

            if ($request->file('image')) {
                $sliderImage =  $home_slider->id . '_image.' . pathinfo($request->file('image')
                    ->getClientOriginalName(), PATHINFO_EXTENSION);
                $request->file('image')->storeAs('home_slider_images', $sliderImage, 'public');
            }

            HomeSlider::where('id', $home_slider->id)->update([
                'image' =>  $sliderImage,
            ]);

            DB::commit();
            return response()->json(['message' => 'Home Slider updated successfully'], 200);
        } catch (\Exception $exception) {
            DB::rollback();
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\HomeSlider  $homeSlider
     * @return \Illuminate\Http\Response
     */
    public function destroy(HomeSlider $homeSlider)
    {
        //
    }
}
