<?php

namespace App\Http\Controllers\Admin\FlightDestinations;

use stdClass;
use App\Models\Admin\City;
use App\Models\Admin\State;
use Illuminate\Http\Request;
use App\Models\Admin\Country;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Models\Admin\FlightDestination;

class FlightDestinationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.managements.flight-destination.index');
    }

    public function getAll()
    {

        try {
            $data = FlightDestination::select('id', 'name', 'code')->where('is_active', 1)
                ->orderBy('name', 'asc')
                ->get();
            return response()->json($data, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            // dd($request->all());
            $flightDestination = new flightDestination();

            $addressLoc = $request->input('location');

            $stateId = State::where('name', $addressLoc['state'])->pluck('id')->first();

            $city = City::select('id', 'state_id', 'name', 'is_active')
                ->where('name', 'LIKE', '%' . $addressLoc['city'] . '%')
                ->whereHas('state', function ($query) use ($stateId) {
                    $query->where('id', $stateId);
                })
                ->first();

            $flightDestination->state_id = $city ? $city->state_id:$stateId;
            $flightDestination->city_id = $city? $city->id : 0;
            $flightDestination->location = $request->location;
            $flightDestination->name = $request->name;
            $flightDestination->code = $request->code;

            $flightDestination->save();

            return response()->json(['message' => 'Flight Destination saved successfully'], 201);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\FlightDestination  $flightDestination
     * @return \Illuminate\Http\Response
     */
    public function show(FlightDestination $flightDestination)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\FlightDestination  $flightDestination
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {

            $flightDestination = FlightDestination::findOrFail($id);

            return response()->json($flightDestination);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\FlightDestination  $flightDestination
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            $flightDestination = FlightDestination::findOrFail($id);

            $addressLoc = $request->input('location');

            $stateId = State::where('name', $addressLoc['state'])->pluck('id');

            $city = City::select('id', 'state_id', 'name', 'is_active')
                ->where('name', $addressLoc['city'])
                ->whereHas('state', function ($query) use ($stateId) {
                    $query->where('id', $stateId);
                })
                ->first();

            $flightDestination->state_id = $city ? $city->state_id:$stateId;
            $flightDestination->city_id = $city? $city->id : 0;
            $flightDestination->location = $request->location;
            $flightDestination->name = $request->name;
            $flightDestination->code = $request->code;

            $flightDestination->save();

            return response()->json(['message' => 'Flight Destination updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\FlightDestination  $flightDestination
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {

        $flightDestination = FlightDestination::findOrFail($id);
        $flightDestination->delete();
        return response()->json(['message' => 'Flight Destination deleted successfully']);
    }

    public function getData(Request $request)
    {
        try {
            $obj = new stdClass();

            $data = FlightDestination::with(['state', 'city' => function ($query) {
                $query->select('id', 'name');
            }])
                ->select('id', 'name', 'location', 'code', 'state_id', 'city_id', 'is_active');

            // Check for 'city_id' in the request and it's not empty
            if (!empty($request['city_id'])) {
                $data->where('city_id', $request['city_id']);
            }
            // Check for 'state_id' in the request and it's not empty
            else if (!empty($request['state_id'])) {
                $data->where('state_id', $request['state_id']);
            }
            // Check for 'country_id' in the request and it's not empty
            else if (!empty($request['country_id'])) {
                // Use a subquery for selecting state IDs
                $data->whereIn('state_id', function ($query) use ($request) {
                    $query->select('id')
                        ->from('states')
                        ->where('country_id', $request['country_id']);
                });
            }

            $data = $data->orderBy('name', 'ASC')->get();

            $obj->data = $data;

            return response()->json($obj, 200);
            // $obj = new stdClass();
            // $obj->data = FlightDestination::select('id', 'name', 'state_id', 'city_id', 'code', 'is_active')
            // ->where('city_id', $cityId)->orderby('name', 'ASC')->get();

            // return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getFormData()
    {
        try {
            $obj = new stdClass();
            $obj->allStates = State::select('id', 'name')->where('is_active', 1)->get();
            $obj->allCities = City::select('id', 'name')->whereIn('state_id', [23, 34])->where('is_active', 1)->get();

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function updateIsActive(Request $request, $id)
    {
        try {
            FlightDestination::whereId($id)->update([
                'is_active' => $request->status
            ]);

            return response()->json(['message' => 'Flight Destination status updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
}
