<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Models\Admin\Feature;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class FeatureController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $features = Feature::select('id', 'title', 'description', 'image')->orderby('title', 'ASC')->get();

        return view('admin.features.index', [
            'features' => $features
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            DB::beginTransaction();

            $feature = new Feature();

            $feature->user_id = Auth::id();
            $feature->title = $request->title;
            $feature->description = $request->description;

            $feature->save();

            $featureImage = null;

            if ($request->file('image')) {
                $featureImage =  $feature->id . '_image.' . pathinfo($request->file('image')
                ->getClientOriginalName(), PATHINFO_EXTENSION);
                $request->file('image')->storeAs('feature_images', $featureImage, 'public');
            }

            Feature::where('id', $feature->id)->update([
                'image' =>  $featureImage,
            ]);

            DB::commit();
            return response()->json(['message' => 'Feature added successfully'], 201);
        } catch (\Exception $exception) {
            DB::rollback();
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Feature  $feature
     * @return \Illuminate\Http\Response
     */
    public function show(Feature $feature)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Feature  $feature
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            // feature
            $feature = Feature::whereId($id)->first();

            return response()->json($feature, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Feature  $feature
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            DB::beginTransaction();

            $feature = Feature::findOrFail($id);

            $feature->title = $request->title;
            $feature->description = $request->description;

            $feature->save();

            $featureImage = $request->file('image');

            if ($request->file('image')) {
                $featureImage =  $feature->id . '_image.' . pathinfo($request->file('image')
                ->getClientOriginalName(), PATHINFO_EXTENSION);
                $request->file('image')->storeAs('feature_images', $featureImage, 'public');
            }

            Feature::where('id', $feature->id)->update([
                'image' =>  $featureImage,
            ]);

            DB::commit();
            return response()->json(['message' => 'Feature updated successfully'], 200);
        } catch (\Exception $exception) {
            DB::rollback();
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Feature  $feature
     * @return \Illuminate\Http\Response
     */
    public function destroy(Feature $feature)
    {
        //
    }
}
