<?php

namespace App\Http\Controllers\Admin;

use DB;
use stdClass;
use GuzzleHttp\Client;
use App\Models\Admin\City;
use App\Models\Admin\State;
use Illuminate\Http\Request;
use App\Models\Admin\Airline;
use App\Models\Admin\Airport;
use App\Models\Admin\Vehicle;
use App\Models\Admin\ZipCode;
use App\Models\Admin\Services;
use App\Models\Admin\Reservation;
use App\Http\Controllers\Controller;
use App\Models\Admin\TravellerTypes;
use Illuminate\Support\Facades\Auth;
use App\Models\Admin\ScheduleService;
use App\Models\Admin\FlightDestination;
use App\Models\Admin\CitiesServicesSettings;

class FareQuotesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.fare-quotes.index');
    }

    public function indexV1()
    {
        return view('admin.fare-quotes.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function getFareQuotesData(){
        try {
            $obj = new stdClass();
            $obj->allServices = Services::select('id', 'service_name')->where('is_active', 1)->get();
            $obj->allAirports = Airport::select('id', 'name', 'airport_location')->where('is_active', 1)->get();
            $obj->allAirlines = Airline::select('id', 'airline_name')->where('is_active', 1)->get();
            $obj->allFlightDestinations = FlightDestination::select('id', 'name', 'code')->where('is_active', 1)->get();
            $obj->allTravellerTypes = TravellerTypes::select('id', 'name', 'count')->where('is_active', 1)->get();

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }

    }
    public function getSelectedServiceData(){
        try {
            $obj = new stdClass();
            $obj->allTravellerTypes = TravellerTypes::select('id', 'name', 'count')->where('is_active', 1)->get();
            $obj->allVehicleTypes = Vehicle::select('id', 'vehicles_type', 'passengers_capacity', 'luggage_capacity')->where('is_active', 1)->get();

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getServices($cityId)
    {
        try {
            $obj = new stdClass();
            $obj->allServices = City::select('id', 'services', 'schedule_services')
                ->where('id', $cityId)
                ->where('is_active', 1)
                ->get();

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getCityServices(Request $request)
    {
        // dd($request->all());

        try {

            if(isset($request->pickupState) && isset($request->pickupCity)){

                $pickUpStateId = State::select('id')->where('name', $request->pickupState)->pluck('id')->first();

                $pickupCityId = City::where('state_id', $pickUpStateId)
                    ->where('name', $request->pickupCity)
                    ->whereRaw('is_active = 1 AND is_reserved = 1')
                    ->pluck('id')
                    ->first();

            }

            if(isset($request->dropOffState) && isset($request->dropOffCity)){

                $dropOffStateId = State::select('id')->where('name', $request->dropOffState)->pluck('id')->first();

                $dropOffCityId = City::select('id')
                    ->where('state_id', $dropOffStateId)
                    ->where('name', $request->dropOffCity)
                    ->whereRaw('is_active = 1 AND is_reserved = 1')
                    ->pluck('id')
                    ->first();
            }

            else if($request->post_code !== ''){

                $pickupCityId = ZipCode::select('id', 'city_id')
                    ->where('zip_code', $request->post_code)
                    ->pluck('city_id')
                    ->first();
            }
            else {
                $obj = '';
            }

            $obj = new stdClass();

            if (isset($pickupCityId, $dropOffCityId)) {
                $allCityServicesDropOff = CitiesServicesSettings::select('id')
                ->where('city_id', $dropOffCityId)
                ->where('service_id', $request->service_id)
                ->first();

                $reservation_id = $request->reservationId ? $request->reservationId : null;
                $round_trip_id = $request->roundTripId ? $request->roundTripId : null;

                if($request->round_trip_booking ||
                    ( $request->is_edit_reservation && $request->airport_ride == 'from_airport')||
                    ($request->is_edit_reservation && $request->service_id == 3 && $round_trip_id < $reservation_id))
                {
                    $obj->allCityServices = $allCityServicesDropOff ?
                        CitiesServicesSettings::select('id', 'city_id', 'service_id', 'services', 'schedule_services')
                        ->where('city_id', $dropOffCityId)
                        ->where('service_id', $request->service_id)
                        ->first() : '';
                }
                else{

                    $obj->allCityServices = $allCityServicesDropOff ?
                        CitiesServicesSettings::select('id', 'city_id', 'service_id', 'services', 'schedule_services')
                        ->where('city_id', $pickupCityId)
                        ->where('service_id', $request->service_id)
                        ->first() : '';
                }

            } else {
                $obj->allCityServices = '';
            }

            // dd($obj->allCityServices);

            $services = [] ;
            $tempServices = [];

            if($obj->allCityServices){
                foreach ($obj->allCityServices->services['services'] as $service) {
                    if($service['is_checked']){
                        $tempCharges = [];
                        foreach($service['millage_service']['additional_millage_charges'] as  $key => $charges){
                            if(isset($charges['price']) && (@$charges['price'] > 0 ||  $charges['is_percentage'] > 0)){
                                $tempCharges[] = $charges;
                            }
                        }
                        $service['millage_service']['additional_millage_charges']=  $tempCharges;
                        array_push($services, $service );
                    }
                }
            }

            if ($obj->allCityServices){
                $tempServices['services']['reservation_hours'] =  $obj->allCityServices->services['reservation_hours'];
                $tempServices['services']['reservation_minutes'] =  $obj->allCityServices->services['reservation_minutes'];
                $tempServices['services']['cancel_hours'] =  $obj->allCityServices->services['cancel_hours'];
                $tempServices['services']['cancel_minute'] =  $obj->allCityServices->services['cancel_minute'];
                $tempServices['services']['wait_time_limit'] =  $obj->allCityServices->services['wait_time_limit'];
                $tempServices['services']['wait_time_charges'] =  $obj->allCityServices->services['wait_time_charges'];
                $tempServices['services']['change_all_charges'] =  $obj->allCityServices->services['change_all_charges'];
                $tempServices['services']['services'] =  $services;
            }


            return response()->json($tempServices, 200);
            // return response()->json($obj->allCityServices, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function getCityScheduleServices(Request $request)
    {
        try {

            if($request->rideType == 'to_airport'){
                $scheduleServices = ScheduleService::where('pickup_address', $request->pickupAddress)
                    ->where('drop_off_address', $request->dropOffAddress)
                    ->get();

                // $scheduleServices = $scheduleServicesData->filter(function ($service) use ($request) {
                //     $dropOffTime = strtotime($service->drop_off_time);
                //     $departureTime = strtotime($request->departureTime);
                //     $pickupTime = ($service->pickup_hours * 3600) + ($service->pickup_minutes * 60);
                //     $targetTime = $departureTime - $pickupTime;

                //     return $dropOffTime <= $targetTime;
                // });
                // $scheduleServices = $scheduleServicesData;
            }
            else{
                $scheduleServices = ScheduleService::where('pickup_address', $request->pickupAddress)
                    ->where('drop_off_address', $request->dropOffAddress)
                    ->get();
            }

            // dd($scheduleServices);


            $reservationsInfo = [];

            foreach ($scheduleServices as $scheduleService) {
                $vehicle_type_id = $scheduleService->vehicle_type_id;
                $vehicle_capacity = $scheduleService->vehicle_capacity;
                $pick_up_time = $scheduleService->pick_up_time;

                $booked_reservations = Reservation::where('service_type_id', $request->service_id)
                    ->where('departure_pick_up_date', $request->departureDate)
                    ->where('pick_up_location->address', $request->pickupAddress)
                    ->where('drop_off_location->address', $request->dropOffAddress)
                    ->where('vehicle_type_id', $vehicle_type_id)
                    ->where('pick_up_time', $pick_up_time)
                    ->select('travellers')
                    ->get();

                $total_travelers = $booked_reservations->sum('travellers');

                if ($total_travelers < $vehicle_capacity) {
                    $scheduleService->total_travelers = $total_travelers;
                    $reservationsInfo[] = $scheduleService;
                }
            }

            return response()->json($reservationsInfo, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    // public function getDistance(Request $request)
    // {
    //     try {
    //         if ($request->from !== '' && $request->to !== '') {

    //             $obj = new stdClass();

    //             $origin = urlencode($request->from);
    //             $destination = urlencode($request->to);
    //             $waypoints = [];

    //             if (!empty($request->additionalStops)) {
    //                 foreach ($request->additionalStops as $stop) {
    //                     $waypoints[] = urlencode($stop['address']);
    //                 }
    //             }

    //             $total_distance = 0;
    //             $total_duration = 0;
    //             $duration_text = '';
    //             $previous_destination = $origin;

    //             if (!empty($waypoints)) {
    //                 foreach ($waypoints as $waypoint) {
    //                     $distance_data = file_get_contents('https://maps.googleapis.com/maps/api/distancematrix/json?&origins=' . $previous_destination . '&destinations=' . $waypoint . '&key=AIzaSyClBMaAaaRWoxV6N5jT1RfFdyeEUS0VhAE');
    //                     $distance_data = json_decode($distance_data, true);

    //                     $distance = $distance_data['rows'][0]['elements'][0]['distance']['value'];
    //                     $duration = $distance_data['rows'][0]['elements'][0]['duration']['value'];
    //                     $duration_text .= $distance_data['rows'][0]["elements"][0]["duration"]["text"] . ", ";
    //                     $total_distance += $distance;
    //                     $total_duration += $duration;
    //                     $previous_destination = $waypoint;
    //                 }
    //             }

    //             $distance_data = file_get_contents('https://maps.googleapis.com/maps/api/distancematrix/json?&origins=' . $previous_destination . '&destinations=' . $destination . '&key=AIzaSyClBMaAaaRWoxV6N5jT1RfFdyeEUS0VhAE');
    //             $distance_data = json_decode($distance_data, true);

    //             $distance = $distance_data['rows'][0]['elements'][0]['distance']['value'];
    //             $duration = $distance_data['rows'][0]['elements'][0]['duration']['value'];
    //             $total_distance += $distance;
    //             $total_duration += $duration;

    //             $duration_text = substr($duration_text, 0, -2);

    //             $hours = floor($total_duration / 3600);
    //             $minutes = floor(($total_duration / 60) % 60);

    //             if ($hours > 0
    //             ) {
    //                 $duration_text = $hours . " hour" . ($hours > 1 ? "s" : "") . " " . $minutes . " minute" . ($minutes > 1 ? "s" : "");
    //             } else {
    //                 $duration_text = $minutes . " minute" . ($minutes > 1 ? "s" : "");
    //             }

    //             $obj->time_duration_text = $duration_text;

    //             $time_hours = $total_duration / 3600;

    //             $distance_in_miles = $total_distance / 1000 * 0.621371;

    //             $obj->distance_formatted = number_format($distance_in_miles, 2);
    //             $obj->time_hours_formatted = number_format($time_hours, 2);
    //         }

    //         changes uncomment by awais
    //         if($request->from !== '' && $request->to !== '') {

    //             $obj = new stdClass();

    //             $origin = urlencode($request->from);
    //             $destination = urlencode($request->to);
    //             $waypoints = [];

    //             if (!empty($request->additionalStops)) {
    //                 foreach ($request->additionalStops as $stop) {
    //                     $waypoints[] = urlencode($stop['address']);
    //                 }
    //             }

    //             $total_distance = 0;
    //             $total_duration = 0;
    //             $duration_text = '';
    //             $previous_destination = $origin;

    //             foreach ($waypoints as $waypoint) {
    //                 $distance_data = file_get_contents('https://maps.googleapis.com/maps/api/distancematrix/json?&origins=' . $previous_destination . '&destinations=' . $waypoint . '&mode=driving&key=AIzaSyClBMaAaaRWoxV6N5jT1RfFdyeEUS0VhAE');
    //                 $distance_data = json_decode($distance_data, true);

    //                 $distance = $distance_data['rows'][0]['elements'][0]['distance']['value'];
    //                 $duration = $distance_data['rows'][0]['elements'][0]['duration']['value'];
    //                 $duration_text .= $distance_data['rows'][0]["elements"][0]["duration"]["text"] . ", ";
    //                 $total_distance += $distance;
    //                 $total_duration += $duration;
    //                 $previous_destination = $waypoint;
    //             }

    //             $distance_data = file_get_contents('https://maps.googleapis.com/maps/api/distancematrix/json?&origins=' . $previous_destination . '&destinations=' . $destination . '&mode=driving&key=AIzaSyClBMaAaaRWoxV6N5jT1RfFdyeEUS0VhAE');
    //             $distance_data = json_decode($distance_data, true);

    //             $distance = $distance_data['rows'][0]['elements'][0]['distance']['value'];
    //             $duration = $distance_data['rows'][0]['elements'][0]['duration']['value'];
    //             $total_distance += $distance;
    //             $total_duration += $duration;

    //             $duration_text = substr($duration_text, 0, -2);

    //             $hours = floor($total_duration / 3600);
    //             $minutes = floor(($total_duration / 60) % 60);

    //             if ($hours > 0) {
    //                 $duration_text = $hours . " hour" . ($hours > 1 ? "s" : "") . " " . $minutes . " minute" . ($minutes > 1 ? "s" : "");
    //             } else {
    //                 $duration_text = $minutes . " minute" . ($minutes > 1 ? "s" : "");
    //             }

    //             $obj->time_duration_text = $duration_text;

    //             $time_hours = $total_duration / 3600;

    //             $distance_in_miles = $total_distance / 1000 * 0.621371;

    //             $obj->distance_formatted = number_format($distance_in_miles, 2);
    //             $obj->time_hours_formatted = number_format($time_hours, 2);

    //         }
    //         else{
    //             $obj = '';
    //         }
    //         return response()->json($obj, 200);
    //     } catch (\Exception $exception) {
    //         return response()->json(['error' => $exception->getMessage()], 500);
    //     }
    // }

    public function getDistance(Request $request)
    {
        try {
            // dd($request->all());
            if ($request->from !== '' && $request->to !== '') {

                $obj = new stdClass();

                $origin = urlencode($request->from);
                $destination = urlencode($request->to);
                $waypoints = [];

                if (!empty($request->additionalStops)) {
                    foreach ($request->additionalStops as $stop) {
                        if(isset($stop['address']))
                        $waypoints[] = urlencode($stop['address']);
                    }
                }

                $total_distance = 0;
                $total_duration = 0;
                $duration_text = '';
                $previous_destination = $origin;

                if (!empty($waypoints)) {
                    foreach ($waypoints as $waypoint) {
                        $url = 'https://maps.googleapis.com/maps/api/distancematrix/json?&origins=' . $previous_destination . '&destinations=' . $waypoint . '&key=AIzaSyClBMaAaaRWoxV6N5jT1RfFdyeEUS0VhAE';

                        $ch = curl_init($url);
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                        $distance_data = curl_exec($ch);

                        if (curl_errno($ch)) {
                            // Handle the cURL error here
                            return response()->json(['error' => curl_error($ch)], 500);
                        }

                        curl_close($ch);

                        $distance_data = json_decode($distance_data, true);

                        $distance = $distance_data['rows'][0]['elements'][0]['distance']['value'];
                        $duration = $distance_data['rows'][0]['elements'][0]['duration']['value'];
                        $duration_text .= $distance_data['rows'][0]["elements"][0]["duration"]["text"] . ", ";
                        $total_distance += $distance;
                        $total_duration += $duration;
                        $previous_destination = $waypoint;
                    }
                }

                $url = 'https://maps.googleapis.com/maps/api/distancematrix/json?&origins=' . $previous_destination . '&destinations=' . $destination . '&key=AIzaSyClBMaAaaRWoxV6N5jT1RfFdyeEUS0VhAE';

                $ch = curl_init($url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                $distance_data = curl_exec($ch);

                if (curl_errno($ch)) {
                    // Handle the cURL error here
                    return response()->json(['error' => curl_error($ch)], 500);
                }

                curl_close($ch);

                $distance_data = json_decode($distance_data, true);

                $distance = $distance_data['rows'][0]['elements'][0]['distance']['value'];
                $duration = $distance_data['rows'][0]['elements'][0]['duration']['value'];
                $total_distance += $distance;
                $total_duration += $duration;

                $duration_text = substr($duration_text, 0, -2);

                $hours = floor($total_duration / 3600);
                $minutes = floor(($total_duration / 60) % 60);

                if ($hours > 0) {
                    $duration_text = $hours . " hour" . ($hours > 1 ? "s" : "") . " " . $minutes . " minute" . ($minutes > 1 ? "s" : "");
                } else {
                    $duration_text = $minutes . " minute" . ($minutes > 1 ? "s" : "");
                }

                $obj->time_duration_text = $duration_text;

                $time_hours = $total_duration / 3600;

                $distance_in_miles = $total_distance / 1000 * 0.621371;

                $obj->distance_formatted = number_format($distance_in_miles, 2);
                $obj->time_hours_formatted = number_format($time_hours, 2);
                $obj->hours = $hours;
                $obj->minutes = $minutes;
            } else {
                $obj = '';
            }
            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()],500);
        }
    }

    public function getZipCodesData($cityId)
    {
        try {
            $obj = new stdClass();

            $data = ZipCode::select('id', 'zip_code')->where('city_id', $cityId)->get();

            $obj->data = $data;

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getZipCodesServicesData($zipCode)
    {
        // dd($zipCode);
        try {
            $obj = new stdClass();

            $data = ZipCode::select('id', 'city_id')->where('zip_code', $zipCode)->pluck('city_id')->first();

            dd($data);

            $obj->data = $data;

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
}
