<?php

namespace App\Http\Controllers\Admin\ExpensesHead;

use stdClass;
use Illuminate\Http\Request;
use App\Models\Admin\ExpensesHead;
use App\Http\Controllers\Controller;

class ExpensesHeadController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.managements.expenses-head.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            $expense_head = new ExpensesHead();

            $expense_head->name = $request->name;

            $expense_head->save();

            return response()->json(['message' => 'Expense Head added successfully'], 201);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            $obj = new stdClass();

            $expense_head = ExpensesHead::findOrFail($id);

            $obj->expense_head = $expense_head;

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            $expense_head = ExpensesHead::findOrFail($id);

            $expense_head->name = $request->name;

            $expense_head->save();

            return response()->json(['message' => 'Expense Head updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function getServerData()
    {
        try {
            $data = ExpensesHead::select('id', 'name','is_active','is_report_active')
            ->orderByRaw("CASE WHEN name REGEXP '^[0-9]' THEN 2 ELSE 1 END, name ASC")
            ->get();;

            return response()->json($data, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function updateIsActive(Request $request, $id)
    {
        try {
            ExpensesHead::whereId($id)->update([
                'is_active' => $request->status
            ]);

            return response()->json(['message' => 'Expense Head status updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function updateIsReportActive(Request $request, $id)
    {
        try {
            ExpensesHead::whereId($id)->update([
                'is_report_active' => $request->status
            ]);

            return response()->json(['message' => 'Expense Head status updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
}
