<?php

namespace App\Http\Controllers\Admin\Employees;

use stdClass;
use App\Models\Admin\User;
use Illuminate\Http\Request;
use App\Models\Admin\Country;
use App\Models\Admin\Employee;
use App\Models\Admin\UserGroup;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Models\Admin\EmployeeCategory;

class EmployeeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $employees = Employee::with('country')->with('state')->with('city')->orderby('first_name', 'ASC')->get();
        $countries = Country::select('id', 'name')->where('is_active', 1)->get();
        $userGroups = UserGroup::select('id', 'name')->where('is_active', 1)->get();
        // dd($userGroups);

        return view('admin.employees.index', [
            'employees' => $employees,
            'countries' => $countries,
            'userGroups' => $userGroups,
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // dd($request->all());
        try {
            DB::beginTransaction();
            $user = new User();

            $user->access_key = md5($request->email_address);

            $user->email = $request->email_address;
            $user->password = bcrypt($request->login_password);
            $user->readable_password = $request->login_password;
            $user->parent_id = 1;

            $user->role_id = $request->emp_category_id;

            $user->save();
            $employee = new Employee();

            $employee->user_id = $user->id;

            $employee->emp_category_id = $request->emp_category_id;
            $employee->first_name = $request->first_name;
            $employee->last_name = $request->last_name;
            $employee->email_address = $request->email_address;
            $employee->home_phone = $request->home_phone;
            $employee->cell_phone = $request->cell_phone;
            $employee->gender = $request->gender;
            $employee->cell_phone_provider = $request->cell_phone_provider;
            $employee->dob = $request->dob;
            $employee->date_of_joining = $request->date_of_joining;
            $employee->date_of_last_employment = $request->date_of_last_employment;

            $employee->country_id = $request->country_id;
            $employee->state_id = $request->state_id;
            $employee->city_id = $request->city_id;
            $employee->address = $request->address;
            $employee->postal_code = $request->postal_code;

            $employee->emp_id_number = $request->emp_id_number;
            $employee->emp_id_expiry = $request->emp_id_expiry;
            $employee->emp_license_number = $request->emp_license_number;
            $employee->emp_license_expiry = $request->emp_license_expiry;
            $employee->police_clearance_number = $request->police_clearance_number;
            $employee->policy_number = $request->policy_number;
            $employee->criminal_record_exp = $request->criminal_record_exp;
            $employee->social_security_number = $request->social_security_number;

            $employee->prim_emg_name = $request->prim_emg_name;
            $employee->prim_emg_relation = $request->prim_emg_relation;
            $employee->prim_emg_phone = $request->prim_emg_phone;
            $employee->prim_emg_mobile = $request->prim_emg_mobile;
            $employee->prim_emg_address = $request->prim_emg_address;
            $employee->sec_emg_name = $request->sec_emg_name;
            $employee->sec_emg_relation = $request->sec_emg_relation;
            $employee->sec_emg_phone = $request->sec_emg_phone;
            $employee->sec_emg_mobile = $request->sec_emg_mobile;
            $employee->sec_emg_address = $request->sec_emg_address;
            $employee->status = 'Active';

            $employee->save();

            $profileImage = null;
            $employeeLicenseImage = null;
            $policeClearanceImage = null;
            $drivingLicenseBack = null;
            $policyImage = null;

            if ($request->file('profile_image')) {
                $profileImage =  $employee->id . '_profile_image.' . pathinfo($request->file('profile_image')
                ->getClientOriginalName(), PATHINFO_EXTENSION);
                $request->file('profile_image')->storeAs('employee_images/profile_images', $profileImage, 'public');
            }
            if ($request->file('emp_license_image')) {
                $employeeLicenseImage = $employee->id . '_emp_license_image.' . pathinfo($request->file('emp_license_image')
                ->getClientOriginalName(), PATHINFO_EXTENSION);
                $request->file('emp_license_image')->storeAs('employee_images/emp_license_images', $employeeLicenseImage, 'public');
            }
            if ($request->file('police_clearance_image')) {
                $policeClearanceImage = $employee->id . '_police_clearance_image.' . pathinfo($request->file('police_clearance_image')
                ->getClientOriginalName(), PATHINFO_EXTENSION);
                $request->file('police_clearance_image')->storeAs('employee_images/police_clearance_images', $policeClearanceImage, 'public');
            }
            if ($request->file('driving_license_back')) {
                $drivingLicenseBack = $employee->id . '_driving_license_back.' . pathinfo($request->file('driving_license_back')->getClientOriginalName(), PATHINFO_EXTENSION);
                $request->file('driving_license_back')->storeAs('employee_images/driving_license_backs', $drivingLicenseBack, 'public');
            }
            if ($request->file('policy_image')) {
                $policyImage = $employee->id . '_policy_image.' . pathinfo($request->file('policy_image')->getClientOriginalName(), PATHINFO_EXTENSION);
                $request->file('policy_image')->storeAs('employee_images/policy_images', $policyImage, 'public');
            }

            Employee::where('id', $employee->id)->update([
                'profile_image' =>  $profileImage,
                'emp_license_image' =>  $employeeLicenseImage,
                'police_clearance_image' =>  $policeClearanceImage,
                'driving_license_back' =>  $drivingLicenseBack,
                'policy_image' =>  $policyImage,
            ]);

            DB::commit();
            return response()->json(['message' => 'Employee added successfully'], 201);
        } catch (\Exception $exception) {
            DB::rollback();
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            // employee
            $obj = new stdClass();

            $obj->employee = Employee::whereId($id)->first();
            $obj->password = User::whereId($obj->employee->user_id)->pluck('readable_password')->first();
            $obj->authId = Auth::id();

            // dd($employee);
            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // dd($request->all());
        try {

            $employee = Employee::findOrFail($id);
            // dd($employee);

                $user = User::find($employee->user_id);
                // dd($user);
                if($user)
                {
                    $user->access_key = md5($request->email_address);

                    $user->email = $request->email_address;
                    if($request->login_password){
                        $user->password = bcrypt($request->login_password);
                        $user->readable_password = $request->login_password;
                    }
                    $user->parent_id = 1;

                    $user->role_id = $request->emp_category_id;

                    $user->save();
                }
                else{
                    $user = new User();

                    $user->access_key = md5($request->email_address);

                    $user->email = $request->email_address;
                    $user->password = bcrypt($request->login_password);
                    $user->readable_password = $request->login_password;
                    $user->parent_id = 1;

                    $user->role_id = $request->emp_category_id;

                    $user->save();
                }
            $employee->emp_category_id = $request->emp_category_id;
            $employee->first_name = $request->first_name;
            $employee->last_name = $request->last_name;
            $employee->email_address = $request->email_address;
            $employee->home_phone = $request->home_phone;
            $employee->cell_phone = $request->cell_phone;
            $employee->gender = $request->gender;
            $employee->cell_phone_provider = $request->cell_phone_provider;
            $employee->dob = $request->dob;
            $employee->date_of_joining = $request->date_of_joining;
            $employee->date_of_last_employment = $request->date_of_last_employment;

            $employee->country_id = $request->country_id;
            $employee->state_id = $request->state_id;
            $employee->city_id = $request->city_id;
            $employee->address = $request->address;
            $employee->postal_code = $request->postal_code;

            $employee->emp_id_number = $request->emp_id_number;
            $employee->emp_id_expiry = $request->emp_id_expiry;
            $employee->emp_license_number = $request->emp_license_number;
            $employee->emp_license_expiry = $request->emp_license_expiry;
            $employee->police_clearance_number = $request->police_clearance_number;
            $employee->policy_number = $request->policy_number;
            $employee->criminal_record_exp = $request->criminal_record_exp;
            $employee->social_security_number = $request->social_security_number;

            $employee->prim_emg_name = $request->prim_emg_name;
            $employee->prim_emg_relation = $request->prim_emg_relation;
            $employee->prim_emg_phone = $request->prim_emg_phone;
            $employee->prim_emg_mobile = $request->prim_emg_mobile;
            $employee->prim_emg_address = $request->prim_emg_address;
            $employee->sec_emg_name = $request->sec_emg_name;
            $employee->sec_emg_relation = $request->sec_emg_relation;
            $employee->sec_emg_phone = $request->sec_emg_phone;
            $employee->sec_emg_mobile = $request->sec_emg_mobile;
            $employee->sec_emg_address = $request->sec_emg_address;

            $employee->save();

            $profileImage = $request->file('profile_image');
            $employeeLicenseImage = $request->file('emp_license_image');
            $policeClearanceImage = $request->file('police_clearance_image');
            $drivingLicenseBack = $request->file('driving_license_back');
            $policyImage = $request->file('policy_image');

            if ($request->file('profile_image')) {
                $profileImage =  $employee->id . '_profile_image.' . pathinfo($request->file('profile_image')
                ->getClientOriginalName(), PATHINFO_EXTENSION);
                $request->file('profile_image')->storeAs('employee_images/profile_images', $profileImage, 'public');
            } else {
                // If no new profile image is provided, retain the previous image
                $profileImage = $employee->profile_image;
            }
            if ($request->file('emp_license_image')) {
                $employeeLicenseImage = $employee->id . '_emp_license_image.' . pathinfo($request->file('emp_license_image')
                ->getClientOriginalName(), PATHINFO_EXTENSION);
                $request->file('emp_license_image')->storeAs('employee_images/emp_license_images', $employeeLicenseImage, 'public');
            }
            else {
                // If no new profile image is provided, retain the previous image
                $employeeLicenseImage = $employee->emp_license_image;
            }

            if ($request->file('police_clearance_image')) {
                $policeClearanceImage = $employee->id . '_police_clearance_image.' . pathinfo($request->file('police_clearance_image')
                ->getClientOriginalName(), PATHINFO_EXTENSION);
                $request->file('police_clearance_image')->storeAs('employee_images/police_clearance_images', $policeClearanceImage, 'public');
            }
            else {
                // If no new profile image is provided, retain the previous image
                $policeClearanceImage = $employee->police_clearance_image;
            }
            if ($request->file('driving_license_back')) {
                $drivingLicenseBack = $employee->id . '_driving_license_back.' . pathinfo($request->file('driving_license_back')->getClientOriginalName(), PATHINFO_EXTENSION);
                $request->file('driving_license_back')->storeAs('employee_images/driving_license_backs', $drivingLicenseBack, 'public');
            }
            else {
                // If no new profile image is provided, retain the previous image
                $drivingLicenseBack = $employee->driving_license_back;
            }
            if ($request->file('policy_image')) {
                $policyImage = $employee->id . '_policy_image.' . pathinfo($request->file('policy_image')->getClientOriginalName(), PATHINFO_EXTENSION);
                $request->file('policy_image')->storeAs('employee_images/policy_images', $policyImage, 'public');
            }
            else {
                // If no new profile image is provided, retain the previous image
                $policyImage = $employee->policy_image;
            }

            Employee::where('id', $employee->id)->update([
                'profile_image' =>  $profileImage,
                'emp_license_image' =>  $employeeLicenseImage,
                'police_clearance_image' =>  $policeClearanceImage,
                'driving_license_back' =>  $drivingLicenseBack,
                'policy_image' =>  $policyImage,
            ]);

            return response()->json(['message' => 'Employee updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function checkEmail(Request $request)
    {
        if ($request->email_address) {
            // dd($request->email_address);
            if (Employee::where('email_address', '=', $request->email_address)->first()) {
                return response()->json(['isAvailable' => 'no']);
            } else {
                return response()->json(['isAvailable' => 'yes']);
            }
        } else {
            return response()->json(['isAvailable' => 'empty']);
        }
    }

    public function updateIsActive(Request $request, $employeeId)
    {
        try {
            $employee=Employee::findOrFail($employeeId);
            $employee->is_active=$request->status;
            $employee->save();

            $user=User::where('id',$employee->user_id)->first();
            $user->is_active=$request->status;
            $user->save();

            return response()->json(['message' => 'Employee status updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
}
