<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Models\Admin\EmployeeCategory;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\Admin\CarType;
use Illuminate\Support\Facades\Auth;

class EmployeeCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $employeeCategories = EmployeeCategory::select('id', 'category_type', 'is_active')->get();

        return view('admin.employee-categories.index', [
            'employeeCategories' => $employeeCategories
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            DB::beginTransaction();

            $employeeCategory = new EmployeeCategory();

            $employeeCategory->user_id = Auth::id();
            $employeeCategory->category_type = $request->category_type;

            $employeeCategory->save();
            DB::commit();
            return response()->json(['message' => 'Employee Category added successfully'], 201);
        } catch (\Exception $exception) {
            DB::rollback();
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\EmployeeCategory  $employeeCategory
     * @return \Illuminate\Http\Response
     */
    public function show(EmployeeCategory $employeeCategory)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\EmployeeCategory  $employeeCategory
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            // Employee Category
            $employeeCategory = EmployeeCategory::whereId($id)->first();

            return response()->json($employeeCategory, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\EmployeeCategory  $employeeCategory
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            DB::beginTransaction();

            $employeeCategory = EmployeeCategory::findOrFail($id);

            $employeeCategory->category_type = $request->category_type;

            $employeeCategory->save();

            DB::commit();
            return response()->json(['message' => 'Employee Category updated successfully'], 200);
        } catch (\Exception $exception) {
            DB::rollback();
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\EmployeeCategory  $employeeCategory
     * @return \Illuminate\Http\Response
     */
    public function destroy(EmployeeCategory $employeeCategory)
    {
        //
    }
    public function updateIsActive(Request $request, $id)
    {
        try {
            EmployeeCategory::whereId($id)->update([
                'is_active' => $request->status
            ]);

            return response()->json(['message' => 'Employee Category status updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
}
