<?php

namespace App\Http\Controllers\Admin;

use stdClass;
use GuzzleHttp\Client;
use App\Mail\MailHandler;
use App\Models\Admin\City;
use App\Models\Admin\User;
use App\Models\Admin\Phone;
use App\Models\Admin\State;
use App\Models\Admin\Driver;
use Illuminate\Http\Request;
use App\Models\Admin\Country;
use App\Models\Admin\Vehicle;
use App\Models\Admin\Customer;
use App\Models\Admin\Employee;
use Illuminate\Support\Carbon;
use App\Models\Admin\UserGroup;
use App\Models\Admin\ActivityLog;
use App\Models\Admin\Reservation;
use App\Models\Admin\VehicleMake;
use App\Models\Admin\VehiclePart;
use App\Models\Admin\ExpensesHead;
use Illuminate\Support\Facades\DB;
use App\Models\Admin\DriverVehicle;
use App\Models\Admin\GuestCustomer;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use App\Models\Admin\DriverCategory;
use App\Models\Admin\ExpenseDetails;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Models\Admin\SecurityQuestion;
use Illuminate\Support\Facades\Storage;
use App\Models\Admin\VehicleMillageCondition;
use App\Http\Controllers\Email\EmailSentController;
use App\Http\Controllers\Admin\Reservations\ReservationsController;

class DriversController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.drivers.index');
    }

    public function getDriverInfo($driverId){
        try{
            $driver = Driver::select('id', 'first_name')->where('id', $driverId)->first();
          return response()->json($driver, 201);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function dashboard()
    {
        $driverId = Auth::id();
        $driver = Driver::where('id', $driverId)->first();

        return view('driver.drivers.dashboard', [
            'driver' => $driver,
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // dd($request->all());
        try {
            DB::beginTransaction();
            // Create a new resource (driver as user)
            $user = new User();

            $user->access_key = md5($request->email);

            $user->email = $request->email;
            $user->password = bcrypt($request->password);
            $user->readable_password = $request->password;
            $user->parent_id = 1;

            //User group 2 is created for drivers
            $user->role_id = 2;

            $user->save();

            //New Driver object
            $driver = new Driver();
            $addressObj = json_decode($request->input('address_obj'), true);
            // dd($addressObj['state']);
            $driverLocation = City::select('id','state_id', 'name', 'is_active')
            ->with(['state' => function($query) use ($addressObj){
                $query->where('name', $addressObj['state'])->select('id','country_id')->first();
            }])
            ->where('name', $addressObj['city'])
            ->first();

            // dd($driverLocation->id,$driverLocation->state_id,$driverLocation->state->country_id);
            //Foreign key for user
            $driver->user_id = $user->id;

            $driver->category_id = $request->category_id;
            $driver->salary_type = $request->salary_type;
            $driver->salary = $request->salary;
            $driver->first_name = $request->first_name;
            $driver->last_name = $request->last_name;
            $driver->email = $request->email;
            $driver->password = bcrypt($request->password);
            $driver->readable_password = $request->password;
            $driver->home_phone = $request->home_phone;
            $driver->cell_phone = $request->cell_phone;
            $driver->phone_provider_id = $request->phone_provider_id;
            $driver->gender = $request->gender;
            $driver->address_obj = json_decode($request->input('address_obj'));
            $driver->country_id =$driverLocation->state ? $driverLocation->state->country_id: null;
            $driver->state_id = $driverLocation->state_id;
            $driver->city_id = $driverLocation->id;
            $driver->address = $request->address;
            $driver->postal_code = isset($addressObj['postcode']) ? $addressObj['postcode'] : null;
            $driver->driver_id_number = $request->driver_id_number;
            $driver->driver_id_expiry = $request->driver_id_expiry;
            $driver->driving_license_number = $request->driving_license_number;
            $driver->police_clearance_number = $request->police_clearance_number;
            $driver->driver_history = $request->driver_history;
            $driver->insurance_number = $request->insurance_number;
            $driver->dob = $request->dob;
            $driver->social_security_number = $request->social_security_number;
            $driver->date_of_joining = $request->date_of_joining;
            $driver->date_of_last_employment = $request->date_of_last_employment;
            $driver->prim_emg_name = $request->prim_emg_name;
            $driver->prim_emg_relation = $request->prim_emg_relation;
            $driver->prim_emg_phone = $request->prim_emg_phone;
            $driver->prim_emg_mobile = $request->prim_emg_mobile;
            $driver->prim_emg_address = $request->prim_emg_address;
            $driver->sec_emg_name = $request->sec_emg_name;
            $driver->sec_emg_relation = $request->sec_emg_relation;
            $driver->sec_emg_phone = $request->sec_emg_phone;
            $driver->sec_emg_mobile = $request->sec_emg_mobile;
            $driver->sec_emg_address = $request->sec_emg_address;


            $driver->is_active = 1;
            $driver->is_duty_status_active = 1;

            // dd($driver);
            $driver->save();

            $profileImage = null;
            $driverLicenseImage = null;
            $policeClearanceImage = null;
            $driverHistoryImage = null;
            $insuranceImage = null;

            if ($request->file('profile_image')) {
                $requestImage = $request->file('profile_image');
                $imageName = strtolower($driver->id .'_'. str_replace(' ', '_', $requestImage->getClientOriginalName()));
                $destinationPath = storage_path('app/public/driver_images/profile_images');
                $profileImage = $imageName;

                if (!file_exists($destinationPath)) {
                    mkdir($destinationPath, 0777, true);
                }
                $requestImage->move($destinationPath, $imageName);
            }
            if ($request->file('driver_license_image')) {
                $requestImage = $request->file('driver_license_image');
                $imageName = strtolower($driver->id .'_'. str_replace(' ', '_', $requestImage->getClientOriginalName()));
                $destinationPath = storage_path('app/public/driver_images/driver_license_images');
                $driverLicenseImage = $imageName;

                if (!file_exists($destinationPath)) {
                    mkdir($destinationPath, 0777, true);
                }
                $requestImage->move($destinationPath, $imageName);
            }
            if ($request->file('police_clearance_image')) {
                $requestImage = $request->file('police_clearance_image');
                $imageName = strtolower($driver->id .'_'. str_replace(' ', '_', $requestImage->getClientOriginalName()));
                $destinationPath = storage_path('app/public/driver_images/police_clearance_images');
                $policeClearanceImage = $imageName;

                if (!file_exists($destinationPath)) {
                    mkdir($destinationPath, 0777, true);
                }
                $requestImage->move($destinationPath, $imageName);
            }
            if ($request->file('driver_history_image')) {
                $requestImage = $request->file('driver_history_image');
                $imageName = strtolower($driver->id .'_'. str_replace(' ', '_', $requestImage->getClientOriginalName()));
                $destinationPath = storage_path('app/public/driver_images/driver_history_images');
                $driverHistoryImage = $imageName;

                if (!file_exists($destinationPath)) {
                    mkdir($destinationPath, 0777, true);
                }
                $requestImage->move($destinationPath, $imageName);
            }
            if ($request->file('insurance_image')) {
                $requestImage = $request->file('insurance_image');
                $imageName = strtolower($driver->id .'_'. str_replace(' ', '_', $requestImage->getClientOriginalName()));
                $destinationPath = storage_path('app/public/driver_images/insurance_images');
                $insuranceImage = $imageName;

                if (!file_exists($destinationPath)) {
                    mkdir($destinationPath, 0777, true);
                }
                $requestImage->move($destinationPath, $imageName);
            }

            Driver::where('id', $driver->id)->update([
                'profile_image' =>  $profileImage,
                'driver_license_image' =>  $driverLicenseImage,
                'police_clearance_image' =>  $policeClearanceImage,
                'driver_history_image' =>  $driverHistoryImage,
                'insurance_image' =>  $insuranceImage
            ]);

            DB::commit();
            $driver->load('category');
            return response()->json(['message' => 'Driver added successfully','driver' => $driver], 201);
        } catch (\Exception $exception) {
            DB::rollback();
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            $obj = new stdClass();
            $obj->authId = Auth::id();
            $obj->driver = Driver::whereId($id)->with('driver_vehicles')->first();
            $obj->password = Driver::whereId($id)->pluck('readable_password')->first();

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try{
            $driver = Driver::findOrFail($id);

            $addressObj = json_decode($request->input('address_obj'),true);
            if(isset($addressObj['state'])){
                $driverLocation = City::select('id','state_id', 'name', 'is_active')
                ->with(['state' => function($query) use ($addressObj){
                    $query->where('name', $addressObj['state'])->select('id','country_id')->first();
                }])
                ->where('name', $addressObj['city'])
                ->first();

                $driver->address_obj = $request->input('address_obj');
                $driver->country_id = $driverLocation->state ? $driverLocation->state->country_id : null;
                $driver->state_id = $driverLocation->state_id;
                $driver->city_id = $driverLocation->id;
                $driver->address = $request->address;
            }



            if($request->email){
                $user = User::where('id',$request->user_id)->first();
                $user->access_key = md5($request->email);

                $user->email = $request->email;
                $user->password = bcrypt($request->password);
                $user->readable_password = $request->password;

                $user->save();
            }

            $driver->category_id = $request->category_id;
            $driver->salary_type = $request->salary_type;
            $driver->salary = $request->salary;

            $driver->first_name = $request->first_name;
            $driver->last_name = $request->last_name;
            $driver->email = $request->email;
            $driver->password = bcrypt($request->password)?: null;
            $driver->readable_password = $request->password?: null;
            $driver->home_phone = $request->home_phone;
            $driver->cell_phone = $request->cell_phone;
            $driver->phone_provider_id = $request->phone_provider_id;
            $driver->gender = $request->gender;

            $driver->postal_code = isset($addressObj['postcode']) ? $addressObj['postcode'] : null;
            $driver->driver_id_number = $request->driver_id_number;
            $driver->driver_id_expiry = $request->driver_id_expiry;
            $driver->driving_license_number = $request->driving_license_number;
            $driver->police_clearance_number = $request->police_clearance_number;
            $driver->driver_history = $request->driver_history;
            $driver->insurance_number = $request->insurance_number;
            $driver->dob = $request->dob;
            $driver->social_security_number = $request->social_security_number;
            $driver->date_of_joining = $request->date_of_joining;
            $driver->date_of_last_employment = $request->date_of_last_employment;
            $driver->prim_emg_name = $request->prim_emg_name;
            $driver->prim_emg_relation = $request->prim_emg_relation;
            $driver->prim_emg_phone = $request->prim_emg_phone;
            $driver->prim_emg_mobile = $request->prim_emg_mobile;
            $driver->prim_emg_address = $request->prim_emg_address;
            $driver->sec_emg_name = $request->sec_emg_name;
            $driver->sec_emg_relation = $request->sec_emg_relation;
            $driver->sec_emg_phone = $request->sec_emg_phone;
            $driver->sec_emg_mobile = $request->sec_emg_mobile;
            $driver->sec_emg_address = $request->sec_emg_address;


            // dd($driver);
            $driver->save();
            $driverImages =[];


            if ($request->file('profile_image')) {
                $requestImage = $request->file('profile_image');
                $imageName = strtolower($driver->id .'_'. str_replace(' ', '_', $requestImage->getClientOriginalName()));
                $destinationPath = storage_path('app/public/driver_images/profile_images');
                $profileImage = $imageName;

                if (!file_exists($destinationPath)) {
                    mkdir($destinationPath, 0777, true);
                }
                $requestImage->move($destinationPath, $imageName);
                $driverImages['profile_image']  =  $profileImage;
            }
            if ($request->file('driver_license_image')) {
                $requestImage = $request->file('driver_license_image');
                $imageName = strtolower($driver->id .'_'. str_replace(' ', '_', $requestImage->getClientOriginalName()));
                $destinationPath = storage_path('app/public/driver_images/driver_license_images');
                $driverLicenseImage = $imageName;

                if (!file_exists($destinationPath)) {
                    mkdir($destinationPath, 0777, true);
                }
                $requestImage->move($destinationPath, $imageName);
                $driverImages['driver_license_image'] =$driverLicenseImage;
            }
            if ($request->file('police_clearance_image')) {
                $requestImage = $request->file('police_clearance_image');
                $imageName = strtolower($driver->id .'_'. str_replace(' ', '_', $requestImage->getClientOriginalName()));
                $destinationPath = storage_path('app/public/driver_images/police_clearance_images');
                $policeClearanceImage = $imageName;

                if (!file_exists($destinationPath)) {
                    mkdir($destinationPath, 0777, true);
                }
                $requestImage->move($destinationPath, $imageName);
                $driverImages['police_clearance_image'] = $policeClearanceImage;
            }
            if ($request->file('driver_history_image')) {
                $requestImage = $request->file('driver_history_image');
                $imageName = strtolower($driver->id .'_'. str_replace(' ', '_', $requestImage->getClientOriginalName()));
                $destinationPath = storage_path('app/public/driver_images/driver_history_images');
                $driverHistoryImage = $imageName;

                if (!file_exists($destinationPath)) {
                    mkdir($destinationPath, 0777, true);
                }
                $requestImage->move($destinationPath, $imageName);
                $driverImages['driver_history_image'] = $driverHistoryImage;
            }
            if ($request->file('insurance_image')) {
                $requestImage = $request->file('insurance_image');
                $imageName = strtolower($driver->id .'_'. str_replace(' ', '_', $requestImage->getClientOriginalName()));
                $destinationPath = storage_path('app/public/driver_images/insurance_images');
                $insuranceImage = $imageName;

                if (!file_exists($destinationPath)) {
                    mkdir($destinationPath, 0777, true);
                }
                $requestImage->move($destinationPath, $imageName);
                $driverImages['insurance_image'] = $insuranceImage;
            }
            Driver::where('id', $driver->id)->update($driverImages);
            $driver->load('category');
            return response()->json(['message' => 'Driver updated successfully','driver' => $driver], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
            }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $driver=Driver::findOrFail($id);
        $driver->delete();

        return response()->json(['message' => 'Driver deleted successfully!']);
    }

    public function getDriversList(){
        $drivers = Driver::with(['category' => function($q){
            $q->select('id','category_name')->where('is_active',1);
        }])->select('id','category_id','first_name','last_name','email','cell_phone','is_duty_status_active','is_active')
        ->orderby('first_name', 'ASC')
        ->get();

        return response()->json($drivers);
    }

    public function getStates(Request $request){

        $states = State::select('id', 'name')->where('country_id', $request->country_id)->get();

        return response()->json($states, 200);
    }

    public function getCities(Request $request){

        $cities = City::select('id', 'name')->where('state_id', $request->state_id)->get();

        return response()->json($cities, 200);
    }

    public function getAllCustomers(){

        $obj = new stdClass();

        $obj->allRegisteredCustomers = Customer::all();
        $obj->allGuestCustomers = GuestCustomer::all();

        // if($request->customer_type == 'Registered'){
        // }
        // else if($request->customer_type == 'Guest'){
        // }

        return response()->json($obj, 200);
    }

    public function checkEmail(Request $request)
    {
        if ($request->email) {
            if (Driver::where('email', $request->email)->first()) {
                return response()->json(['isAvailable' => 'no']);
            } else {
                return response()->json(['isAvailable' => 'yes']);
            }
        } else {
            return response()->json(['isAvailable' => 'empty']);
        }
    }
    public function checkDriverId(Request $request)
    {
        if ($request->driver_id) {
            $driverIds = Driver::where('driver_id', $request->driver_id)->count();
            if ($driverIds > 0)
                return response()->json(['isAvailable' => 'no']);
            if ($driverIds == 0)
                return response()->json(['isAvailable' => 'yes']);
            else {
                return response()->json(['isAvailable' => 'empty']);
            }
        }
    }
    public function updateIsActive(Request $request, $driverId)
    {
        // dd($request->all());
        try {
            Driver::whereId($driverId)->update([
                'is_active' => $request->status
            ]);

            return response()->json(['message' => 'Driver status updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function updateDutyStatus(Request $request, $driverId)
    {
        // dd($request->all());
        try {
            $driver=Driver::findOrFail($driverId);
            if($request->status == true) {
                $driver->is_duty_status_active = 1;
                //$driver->duty_status = 'On Duty';
            }
            else {
                $driver->is_duty_status_active = 0;
                //$driver->duty_status = 'Off Duty';
            }
            // dd($driver);
            $driver->save();
            // Driver::whereId($driverId)->update([
            //     'is_duty_status_active' => $request->status
            //     if($request->status == 'true'){

            //     }
            // ]);

            return response()->json(['message' => 'Driver Duty status updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function postRequest()
    {
        $client = new Client();
        $response = $client->request('POST', 'https://countriesnow.space/api/v0.1/countries/states', [
            'form_params' => [
                'country' => 'New Zealand',
                ]
        ]);

        $response = $response->getBody()->getContents();
        $response =  json_decode($response);

        $count = count($response->data->states);
        for ($n = 0; $n < $count; $n++) {

            $state_data = new State();
            $state_data->state_name = $response->data->states[$n]->name;
            $state_data->save();
        }

        // return $response->data->states['name'];
    }

    public function getServerData()
    {
        try {
            $obj = new stdClass();
            // $obj->allCountries = Country::select('id', 'name')->where('is_active', 1)->get();
            $obj->allDriverCategories = DriverCategory::select('id', 'category_name')->where('is_active', 1)->orderBy('category_name')->get();
            $obj->allVehicleTypes = Vehicle::select('id', 'vehicles_type')->where('is_active', 1)->orderBy('vehicles_type')->get();
            $obj->allVehicleMakes = VehicleMake::select('id', 'name', 'make')->where('is_active', 1)->orderBy('name')->get();
            $obj->phoneProviders = Phone::select('id', 'name', 'gateway_address')->where('is_active', 1)->orderBy('name')->get();

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }



    // public function getTodayReservations()
    // {
    //     try {
    //         $driverId = Auth::id();

    //         $todayReservations = Reservation::with('Customer')->where('driver_id', $driverId)
    //         ->whereDate('pick_up_date', '=', Carbon::today()->toDateString())
    //         ->where('status', '!=', 'Cancelled')
    //         ->get();

    //         return response()->json($todayReservations, 200);
    //     } catch (\Exception $exception) {
    //         return response()->json(['error' => $exception->getMessage()], 500);
    //     }
    // }

    // public function getTomorrowReservations()
    // {
    //     try {
    //         $driverId = Auth::id();
    //         $tomorrowReservations = Reservation::with('Customer')->where('driver_id', $driverId)
    //         ->whereDate('pick_up_date', '=', Carbon::tomorrow()->toDateString())
    //         ->where('status', '!=', 'Cancelled')
    //         ->get();

    //         return response()->json($tomorrowReservations, 200);
    //     } catch (\Exception $exception) {
    //         return response()->json(['error' => $exception->getMessage()], 500);
    //     }
    // }

    public function getDriverReservations(Request $request)
    {
        try {
            $driver_id = Auth::id();
            // if ($request->search_type === 'today_pickups')  {
            //     $request->merge(['start_date' >= Carbon::today()->toDateString(), 'ending_date' <= Carbon::today()->toDateString()]);
            // }
            // if ($request->search_type === 'tomorrow_pickups')  $request->merge(['start_date' => Carbon::tomorrow()->toDateString()]);
            $request->merge(['driver_id' => $driver_id]);
            $reservations = json_decode(ReservationsController::searchReservations($request)->content(), true);

            return response()->json(["reservations" => $reservations, "sDate" => Carbon::today()->toDateString()], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getVehicleConditionByDate($date,$driver_id)
    {
        try {

            $obj = new stdClass();

            $driverUserId = Driver::where('id', $driver_id)->select('id', 'user_id')->pluck('user_id')->first();

            $obj->driverVehicle = VehicleMillageCondition::select('id', 'vehicle_id', 'miles_start', 'miles_end', 'vehicle_condition')
            ->where('driver_id', $driver_id)
            ->whereDate('created_at', '=', $date)
            ->latest('created_at')
            ->first();

            $driverExpenseDetails = ExpenseDetails::select('id', 'expense_id', 'amount')
            ->where('user_id', $driverUserId)
            ->whereDate('expense_date', '=', $date)
            ->latest('created_at')
            ->get();

            $obj->driverExpenseDetails = $driverExpenseDetails->pluck('amount', 'expense_id')->toArray();

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getRequiredData()
    {
        try {
            $obj = new stdClass();

            $driver_id = Auth::id();

            $driverVehicle = VehicleMillageCondition::select('id', 'vehicle_id', 'miles_start', 'miles_end')
            ->where('driver_id', $driver_id)
            ->latest('created_at')
            ->first();

            if ($driverVehicle && $driverVehicle->miles_start != null && $driverVehicle->miles_end != null) {
                $obj->status = false;
            } else {
                $obj->driverVehicle = $driverVehicle;

                $obj->allVehicle = VehicleMake::select('id', 'name')->where('is_active', 1)->get();
                $obj->expensesHeads = ExpensesHead::select('id', 'name')->where('is_report_active', 1)->where('is_active', 1)->get();

                $obj->status = true;
            }


            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getAllReservationInfo()
    {
        try {
            $obj = new stdClass();

            $vehicles = Vehicle::select('id', 'vehicles_type')->get();

            $obj->vehicles = $vehicles;

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getVehicleMakeData()
    {
        try {
            $obj = new stdClass();

            $driver_id = Auth::id();

            $driverVehicle = VehicleMillageCondition::select('id', 'vehicle_id', 'miles_start', 'miles_end')
            ->where('driver_id', $driver_id)
            ->latest('created_at')
            ->first();

            // dd($driverVehicle);

            if($driverVehicle && $driverVehicle->miles_start != null && $driverVehicle->miles_end != null){
                $obj->allVehicle = VehicleMake::select('id', 'name')->where('is_active', 1)->get();
                $obj->allVehicleParts = VehiclePart::select('id', 'part_name')->where('is_active', 1)->get();
                $obj->status = true;
            }
            else if($driverVehicle && $driverVehicle->miles_start != null && $driverVehicle->miles_end == null){
                $obj->status = false;
            }
            else if(!$driverVehicle){
                $obj->allVehicle = VehicleMake::select('id', 'name')->where('is_active', 1)->get();
                $obj->allVehicleParts = VehiclePart::select('id', 'part_name')->where('is_active', 1)->get();
                $obj->status = true;
            }

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function getEditVehicleMakeData()
    {
        try {
            $obj = new stdClass();

            $driver_id = Auth::id();

            $obj->driverVehicle = VehicleMillageCondition::select('id', 'vehicle_id', 'miles_start', 'miles_end')
            ->where('driver_id', $driver_id)
            ->latest('created_at')
            ->first();

            $obj->expensesHeads = ExpensesHead::select('id', 'name')->where('is_report_active', 1)->where('is_active', 1)->get();
            // dd($driverVehicle);
            $obj->allVehicle = VehicleMake::select('id', 'name','make')->where('is_active', 1)->get();
            $obj->allVehicleParts = VehiclePart::select('id', 'part_name')->where('is_active', 1)->get();

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function getVehicleMillage($id)
    {
        try {
            $vehicleMillage = VehicleMillageCondition::where('vehicle_id', $id)
            ->latest('created_at')
            ->pluck('miles_end')
            ->first();

            return response()->json($vehicleMillage, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function saveDriverVehicle(Request $request)
    {
        try {
        //    dd($request->all());

            $vehicleMillageCondition = new VehicleMillageCondition();

            $vehicleMillageCondition->driver_id = Auth::id();
            $vehicleMillageCondition->vehicle_id = $request->vehicle_id;
            $vehicleMillageCondition->miles_start = $request->miles_start;
            $vehicleMillageCondition->vehicle_condition = $request->conditions;
            $vehicleMillageCondition->notes = $request->notes;

            $vehicleMillageCondition->save();

            return response()->json(['message' => 'Vehicle Selected successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function updateDriverVehicle(Request $request, $id, $date)
    {
        try {

            $driver = Driver::where('id', Auth::id())->select('id', 'first_name', 'last_name', 'user_id')->first();

            // Get all the existing expense IDs for the user on the given date
            $existingExpenseIds = ExpenseDetails::where('user_id', $driver->user_id)
            ->whereDate('expense_date', $date)
            ->pluck('expense_id')
            ->toArray();

            // Iterate through the existing expense IDs and delete those that are not in the request
            foreach ($existingExpenseIds as $existingExpenseId) {
                if (!isset($request->expenses[$existingExpenseId])) {
                    ExpenseDetails::where('user_id', $driver->user_id)
                        ->where('expense_id', $existingExpenseId)
                        ->whereDate('expense_date', $date)
                        ->delete();
                }
            }

            // Loop through the request expenses and update or add as needed
            foreach ($request->expenses as $key => $expenseValue) {
                if (isset($expenseValue)) {
                    // Check if the expense ID exists in the database
                    if (in_array($key, $existingExpenseIds)) {
                        $expense = ExpenseDetails::where('user_id', $driver->user_id)
                        ->where('expense_id', $key)
                        ->whereDate('expense_date', $date)
                        ->first();

                        $expense->amount = floatval($expenseValue);
                        $expense->save();
                    } else {
                        $expense = new ExpenseDetails();
                        $expense->user_id = $driver->user_id;
                        $expense->user_group_id = 2;
                        $expense->user_name = $driver->first_name . ' ' . $driver->last_name;
                        $expense->expense_id = $key;
                        $expense->amount = floatval($expenseValue);
                        $expense->expense_date = $date;
                        $expense->save();
                    }
                }
            }

            $vehicleMillageCondition = VehicleMillageCondition::findOrFail($id);

            $vehicleMillageCondition->vehicle_id = $request->vehicle_id;
            $vehicleMillageCondition->miles_start = $request->miles_start;
            $vehicleMillageCondition->miles_end = $request->miles_end;
            $vehicleMillageCondition->vehicle_condition = $request->conditions;
            $vehicleMillageCondition->notes = $request->notes;

            $vehicleMillageCondition->save();

            return response()->json(['message' => 'Vehicle Selected successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function saveDriverExpenses(Request $request)
    {
        try {
            // dd(Auth::id());
            //Save ending millage
            $vehicleMillageCondition = VehicleMillageCondition::findOrFail($request->id);

            $vehicleMillageCondition->miles_end = $request->miles_end;

            $vehicleMillageCondition->save();

            //Get driver details to put in expenses details
            $driver = Driver::where('id', Auth::id())->select('id', 'first_name', 'last_name', 'user_id')->first();

            foreach($request->expenses as $key => $expenseValue) {
                if ($expenseValue) {
                    $expense = new ExpenseDetails();
                    $expense->user_id = $driver->user_id;
                    $expense->expense_id = $key;
                    $expense->user_group_id = 2;
                    $expense->user_name = $driver->first_name . ' ' . $driver->last_name;
                    $expense->amount = floatval($expenseValue);
                    $expense->expense_date = Carbon::today();

                    $expense->save();
                }
            }

            return response()->json(['message' => 'Day Ended and Expenses updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function updateReservationStatus(Request $request)
    {
        try {
            $reservation_obj = Reservation::findOrFail($request->reservation_id);

            // Update the driver_status
            $reservation_obj->driver_status = $request->driver_status;

            // dd(Carbon::now()->toTimeString());
            if ($request->driver_status === 'Ride Started') {
                $reservation_obj->ride_started_time = Carbon::now()->toTimeString(); // Store only the time
            } elseif ($request->driver_status === 'Completed') {
                $reservation_obj->ride_completed_time = Carbon::now()->toTimeString(); // Store only the time
            }
            // dd($reservation_obj);
            $reservation_obj->save();
            return response()->json(['message' => 'Reservation status updated'], 201);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function driverEmailAuthentication(Request $request){
        // dd($request->all());
        try {
            $driverSecurity = Driver::where('email', $request->email)
                ->select('id','security_question_id')
                ->first();
            // dd($driverSecurity);
            if ($driverSecurity) {
                $securityQuestions = SecurityQuestion::where('id', $driverSecurity->security_question_id)
                    ->select('id','name')
                    ->get();
                // dd($securityQuestions);

                return response()->json(['security_question' => $securityQuestions,'is_valid'=>true]);
            }

            return response()->json('false');
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function checkDriverSecurityAnswer(Request $request){
        try {
            $driver=Driver::where('email',$request->email)
                ->where('security_answer',$request->security_answer)
                ->first();

                if($driver){
                    return response()->json(['is_valid'=>true]);
                }
                return response()->json('false');
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    // public function getDriverAuthentication(Request $request){
    //     try {
    //         // dd($request->all());
    //         $driver=Driver::where('email',$request->email)
    //             ->where('security_question_id',$request->security_question_id)
    //             ->where('security_answer',$request->security_answer)
    //             ->first();
    //         // dd($driver);
    //             if($driver){
    //                 return response()->json('true');
    //             }
    //             return response()->json('false');
    //     } catch (\Exception $exception) {
    //         return response()->json(['error' => $exception->getMessage()], 500);
    //     }
    // }

    public function updatePassword(Request $request){

        // dd($request->all());
        try {
            $driver=Driver::where('email',$request->email)
                ->where('security_answer',$request->security_answer)
                ->first();

            // dd($driver);
            $user=User::where('id',$driver->user_id)
                ->first();
            // dd($user);
                if($driver && $user){

                    $driver->readable_password = $request->password;
                    $driver->password = bcrypt($request->password);
                    $driver->save();

                    $user->readable_password = $request->password;
                    $user->password = bcrypt($request->password);
                    $user->save();
                    return response()->json(['message' => 'Update Password successfully'], 200);
                }
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function checkDriverPassword(Request $request)
    {
        try {
            $driver = Driver::where('id', $request->driver_id)->first();

            if ($driver && Hash::check($request->old_password, $driver->password)) {
                return response()->json(true);
            }
             else {
                return response()->json(false);
            }

       } catch (\Exception $exception) {
           return response()->json(['error' => $exception->getMessage()], 500);
       }
    }
    public function updateDriverPassword(Request $request)
    {
        try {
            $driver=Driver::findOrFail($request->driver_id);
            // dd($customer);
            $user=User::where('id',$driver->user_id)
                ->first();
            if($driver && $user){

                $driver->readable_password = $request->password;
                $driver->password = bcrypt($request->password);
                $driver->save();

                $user->readable_password = $request->password;
                $user->password = bcrypt($request->password);
                $user->save();
                return response()->json(['message' => 'Update Password successfully'], 200);
            }
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function getDriverActivityLog($driverId){
        try {
            // dd($driverId);
            $obj = new stdClass();

            $obj->activity = ActivityLog::where('item_id', $driverId)->orderBy('id', 'desc')->get();

            $userId = ActivityLog::where('item_id', $driverId)
                    ->where('role_id', '<>', 2)
                    ->select('user_id')
                    ->distinct()
                    ->get();
                // Assuming $userId is the result obtained from the previous query
                $userIds = $userId->pluck('user_id');
                // Retrieve names from the Employee table for the selected user IDs
                $obj->user = $userIds ? Employee::whereIn('user_id', $userIds)->select('id','user_id','first_name','last_name')->get(): null;

                $driverId = ActivityLog::where('item_id', $driverId)
                ->where('role_id',2)
                ->select('user_id')
                ->distinct()
                ->get();

                $driverIds = $driverId->pluck('user_id');

                $obj->driver = $driverIds ? Driver::whereIn('id', $driverIds)->select('id','user_id','first_name','last_name')->get() : null;

                $obj->roles=UserGroup::where('id','!=' , 2)->select('id','name')->get();


            // dd($obj);
            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function logout()
    {
        Auth::guard('driver')->logout();
        return redirect()->route('driver.login')->with('message', 'Logout Successfully');
    }

    public function deleteVehicle($vehicleId){
        $vehicle=DriverVehicle::findOrFail($vehicleId);
        $vehicle->delete();

        return response()->json(['message' => 'Vehicle deleted Successfully']);
    }
    public function saveVehicle(Request $request){

        $vehicleData=$request->vehicle;
        $driverId=$request->driver_id;
        if (
            !empty($vehicleData['vehicle_registration_number']) ||
            !empty($vehicleData['vehicle_make_id']) ||
            !empty($vehicleData['vehicle_model_id']) ||
            !empty($vehicleData['vehicle_type_id'])
        ) {
            $vehicle = DriverVehicle::find($vehicleData['id']);
            // If the vehicle doesn't exist, you can choose to create a new one or skip it
            if (!$vehicle) {
                $vehicle = new DriverVehicle();
            }
            $vehicle->driver_id = $driverId;
            $vehicle->vehicle_make_id = $vehicleData['vehicle_make_id'];
            $vehicle->car_number = $vehicleData['car_number'] ?? null;
            $vehicle->vehicle_model_id = $vehicleData['vehicle_model_id'];
            $vehicle->vehicle_type_id = $vehicleData['vehicle_type_id'];
            $vehicle->vehicle_model_year = $vehicleData['vehicle_model_year'] ?? null;
            $vehicle->vehicle_registration_number = $vehicleData['vehicle_registration_number'];
            $vehicle->vehicle_color = $vehicleData['vehicle_color'] ?? null;
            $vehicle->vehicle_plate_no = $vehicleData['vehicle_plate_no'] ?? null;

            // Handle vehicle image upload
            if (is_file($vehicleData['vehicle_image'])) {
                $requestImage = $vehicleData['vehicle_image'];
                $imageName = strtolower($driverId .'_'. str_replace(' ', '_', $requestImage->getClientOriginalName()));
                $destinationPath = storage_path('app/public/driver_images/vehicle_images');
                $vehicle->vehicle_image = $imageName;

                if (!file_exists($destinationPath)) {
                    mkdir($destinationPath, 0777, true);
                }
                $requestImage->move($destinationPath, $imageName);
            }
            else{
                $vehicle->vehicle_image = null;
            }

            // Save the vehicle
            $vehicle->save();
            return response()->json(['message' => 'Vehicle saved successfully','vehicle' => $vehicle]);
        }
        else{
            return response()->json(['message' => 'Fill the Required Fields']);
        }


    }



    public function sendTextMessage(Request $request){

        /* ===== Send Text Message ============*/
        try {
            $reservation = Reservation::with('customer')->with('selectedVehicle')->findOrFail($request['reservation_id']);

            $pickupDateTime = Carbon::parse($reservation->pick_up_date . ' ' . $reservation->pick_up_time)->format('m/d/Y h:i A');
            $departurePickupDateTime = Carbon::parse($reservation->departure_pick_up_date . ' ' . $reservation->departure_pick_up_time)->format('m/d/Y h:i A');
            $additional_stops = is_array($reservation->additional_stops) ? array_column($reservation->additional_stops, 'address') : null;


            $customer_email =  $reservation->customer->email;
            $customer_phone =  $reservation->customer->cell_phone;
            $customer_id    =  $reservation->customer->id;
            $customer_name  =  $reservation->customer->first_name . ' ' .  $reservation->customer->last_name;


        //     if (!$row->driver_id) {
        //         echo "Select driver and save";
        //     } else {

            $driver             =    Driver::with('cellPhoneProvider')->findOrFail($reservation->driver_id);
            $driver_name        =    $driver->first_name . " " . $driver->last_name;


            $fromAddr = "reservations@kcquicksilver.com";
            //Pickup time

        //         // reservation type
            if ($reservation->service_type_id == 1 && $reservation->airport_ride == 'to_airport') {
                $resv_type = "Departure";
            } elseif ($reservation->service_type_id == 1 && $reservation->airport_ride == 'from_airport') {
                $resv_type  = "Arrival";
            } elseif ($reservation->service_type_id == 2) {
                $resv_type  = "Hourly";
            } elseif ($reservation->service_type_id == 3) {
                $resv_type  = "Around Town";
            } elseif ($reservation->service_type_id == 4) {
                $resv_type  = "Schedule";
            }



            $textBody = "$reservation->id $resv_type: " . $pickupDateTime;

            // if ($reservation->service_type_id == 3) {

            //     $total_amount = $reservation->total_fare;
            //     $full_address = $reservation->pick_up_location['address'];
            //     $textBody .= ", " . $reservation->customer->last_name . " " . $reservation->customer->first_name . ","
            //         . " $car_dir: $full_address " . ", Pax#2 $$total_amount (" . $reservation->customer->cell_phone . ") ";
            //     $drop_address = $reservation->drop_off_location['address'];
            //     $textBody .= $car_dir2 . ": " . $drop_address;
            // } else {
            //     $total_amount = $reservation->total_fare;
            //     $textBody .= ", F#$reservation->flight_number " . $reservation->selected_airline . ", " . $reservation->customer->last_name . " " . $reservation->customer->first_name . ","
            //         . " $car_dir: $full_address " . ", Pax#2 $$total_amount (" . $reservation->customer->cell_phone . ") ";
            // }



             $stops = "";
            // foreach ($reservation->additional_stops as $additional_stop) {

            //     $stops .= ', ' . $additional_stop['address'];
            // }

            if (trim($stops)) {
                $textBody .= "  Additional Stops: ";
                $textBody .= trim($stops, ', ') . ' ';
            }


            $mail_message_customer = '<html>
                                <head>
                            </head>
                            <body>
                                <h2>Driver details</h2>
                                <table>
                                    <tr><th style="text-align:left;">Reservation ID: </th><td>' . $reservation->id . '</td></tr>
                                    <tr><th style="text-align:left;">Pickup Date & Time: </th><td>' . $pickupDateTime . '</td></tr>
                                    <tr><th style="text-align:left;">Pax Details: </th><td>'. collect($reservation->travellers_types)->sum('count') .'</td></tr>
                                    <tr><th style="text-align:left;">Your Driver Name: </th><td>' . ucwords($driver_name) . '</td></tr>
		 							<tr><th style="text-align:left;">Your Driver Phone No: </th><td>' . $driver->cell_phone . '</td></tr>
                                </table>
                                </body>
                            </html>';


            $smsSubject    =    $resv_type . " #" . $reservation->id;
            $smsText = $resv_type . " " .$reservation->id. " ";
            $smsText .= "PT:" .$pickupDateTime . ", " ;
            $smsText .= $reservation->service_type_id == 1? ", F#" . $reservation->flight_number . " " . $reservation->selected_airline . ", " . $reservation->selected_flight_destination . " ":"";
            $smsText .= $customer_name . ' (' . $reservation->customer->mobile_number . ')' . " ";
            //$smsText .= ($resv_type==='Departure'?'Pick: '. $reservation->pick_up_location['address'] :'Drop: '. $reservation->drop_off_location['address']) . $reservation->drop_off_location['address'] . " " ;//commented due to error in driver login
            $smsText .= 'Pick: '. $reservation->pick_up_location['address'] .' ';
            $smsText .=  is_array($additional_stops) ? ' Add. Stops:' .  implode(', ', $additional_stops) . " " : " ";
            $smsText .= ' Drop: ' . $reservation->drop_off_location['address'] . ' ';
            $smsText .= 'Pax#' . collect($reservation->travellers_types)->sum('count') . " ";
            $smsText .= '(' . $reservation->selectedVehicle->vehicles_type . ") ";
            $smsText .= 'Lug:' .  $reservation->luggage . " ";
            $smsText .= '$' .  ($reservation->total_fare - $reservation->driver_gratuity) . "+" . $reservation->driver_gratuity." ";
            $smsText .= 'TOTAL $' .  $reservation->total_fare . " ";

            if ($reservation->pay_type_id == 3) {
                $smsText .= '(CC)';
            } elseif ($reservation->pay_type_id == 4) {
                if ($reservation->customer->direct_account_id) {
                    $smsText .=  " (Ac#" . $reservation->customer->direct_account_id.")";
                }
            }elseif ($reservation->pay_type_id == 1) {
                if ($reservation->customer->direct_account_id) {
                    $smsText .=  " (Cash)";
                }
            }

            //Email Customer
            Mail::to($reservation->customer->email)->send(new MailHandler(
                $mail_message_customer,
                "Driver Assigned to your Reservation #" . $reservation->id
            ));

            try{
                Mail::to($driver->email)->send(new MailHandler(
                    $smsText,
                    "Reservation #". $reservation->id . ""
                ));
                $reservation->is_driver_email_sent=1;
                $reservation->save();
            }
            catch (\Exception $exception) {
                return response()->json(['error' => $exception->getMessage()], 401);
            }
            //Email Driver

            // If Driver cell phone and cell provider, send SMS via email
            if ($driver->cellPhoneProvider->gateway_address && $driver->cell_phone) {
                Mail::to($driver->cell_phone . "@" . $driver->cellPhoneProvider->gateway_address)->send(new MailHandler(
                    $smsText,
                    "Reservation #" . $reservation->id . ""
                ));
            }
            return response()->json(['message' => 'Message sent to driver'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 401);
        }


        return response()->json(['message' => 'Message sent successfully']);
    }

    public function sendCustomTextMessage(Request $request)
    {

        /* ===== Send Text Message ============*/
        try {
            $reservation = Reservation::with('customer')->with('selectedVehicle')->findOrFail($request['reservation_id']);

            $driver             =    Driver::with('cellPhoneProvider')->findOrFail($reservation->driver_id);

            $fromAddr = "reservations@kcquicksilver.com";

            try {
                Mail::to($driver->email)->send(new MailHandler(
                    $request['message'],
                    "Reservation #" . $reservation->id . ""
                ));

            } catch (\Exception $exception) {
                return response()->json(['error' => $exception->getMessage()], 401);
            }
            //Email Driver

            // If Driver cell phone and cell provider, send SMS via email
            if ($driver->cellPhoneProvider->gateway_address && $driver->cell_phone) {
                Mail::to($driver->cell_phone . "@" . $driver->cellPhoneProvider->gateway_address)->send(new MailHandler(
                    $request['message'],
                    "Reservation #" . $reservation->id . ""
                ));
            }
            return response()->json(['message' => 'Message sent to driver'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 401);
        }


        return response()->json(['message' => 'Message sent successfully']);
    }

    public function getDriverVehicle(){
        $drivers = Driver::with([
            'category:id,category_name',
            'driver_vehicles:driver_id,vehicle_make_id,vehicle_type_id',
            'driver_vehicles.vehicles:id,name,make',
            'driver_vehicles.vehicleTypes:id,vehicles_type,passengers_capacity,luggage_capacity'
        ])
        ->select('id','first_name','last_name','category_id', 'is_active','is_duty_status_active')
        ->where('is_active', 1)
        ->orderBy('first_name')
        ->get();
        return response()->json($drivers,200);
    }



}
