<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\Admin\DriverCategory;
use Illuminate\Support\Facades\Auth;


class DriverCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $driverCategories = DriverCategory::orderBy('Category_name', 'asc')->get();

        return view('admin.driver-category.index', [
            'driverCategories' => $driverCategories
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try{
            DB::beginTransaction();

            $driverCategory = new DriverCategory();

            $driverCategory->user_id = Auth::id();
            $driverCategory->category_name = $request->category_name;

            $driverCategory->save();

            DB::commit();
            return response()->json(['message' => 'Driver Category added successfully'], 201);
        } catch (\Exception $exception) {
            DB::rollback();
            return response()->json(['error' => $exception->getMessage()], 500);
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\DriverCategory  $driverCategory
     * @return \Illuminate\Http\Response
     */
    public function show(DriverCategory $driverCategory)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\DriverCategory  $driverCategory
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            // driver category
            $driver = DriverCategory::whereId($id)->first();

            return response()->json($driver, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\DriverCategory  $driverCategory
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
       try{
            DB::beginTransaction();

            $driverCategory = DriverCategory::findOrFail($id);

            $driverCategory->category_name = $request->category_name;
            $driverCategory->save();

            DB::commit();
            return response()->json(['message' => 'Driver Category updated successfully'], 200);
       } catch (\Exception $exception) {
            DB::rollback();
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\DriverCategory  $driverCategory
     * @return \Illuminate\Http\Response
     */
    public function destroy(DriverCategory $driverCategory)
    {
        //
    }
    public function updateIsActive(Request $request, $id)
    {
        try {
            DriverCategory::whereId($id)->update([
                'is_active' => $request->status
            ]);

            return response()->json(['message' => 'Driver Category status updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
}
