<?php

namespace App\Http\Controllers\Admin\DiscountRules;

use stdClass;
use Illuminate\Http\Request;
use App\Models\Admin\DiscountRule;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class DiscountRulesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.managements.discount-rules.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            $discount_rule = new DiscountRule();
            $discount_rule->user_id = Auth::id();

            $discount_rule->title = $request->title;
            $discount_rule->no_of_reservations = $request->no_of_reservations;
            $discount_rule->discount = $request->discount;

            $discount_rule->save();

            return response()->json(['message' => 'Discount Rule save successfully'], 201);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            $obj = new stdClass();

            $discount_rule = DiscountRule::findOrFail($id);

            $obj->discount_rule = $discount_rule;

            return response()->json($obj);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            $discount_rule = DiscountRule::findOrFail($id);

            $discount_rule->title = $request->title;
            $discount_rule->no_of_reservations = $request->no_of_reservations;
            $discount_rule->discount = $request->discount;

            $discount_rule->save();

            return response()->json(['message' => 'Discount Rule updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    // get data
    public function getData()
    {
        try {
            $data = DiscountRule::select('id', 'title', 'no_of_reservations', 'discount' , 'is_active')
            ->orderBy('title', 'ASC')->get();

            return response()->json($data, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function updateIsActive(Request $request, $id)
    {
        try {
            DiscountRule::whereId($id)->update([
                'is_active' => $request->status
            ]);

            return response()->json(['message' => 'Discount Rule status updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
}
