<?php

namespace App\Http\Controllers\Admin\DirectAccounts;

use stdClass;
use Illuminate\Http\Request;
use App\Models\Admin\DirectAccount;
use App\Http\Controllers\Controller;

class DirectAccountsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.managements.direct-accounts.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }


     public function getDirectAccounts()
    {

        try {
            $data = DirectAccount::select('id', 'account_name', 'company_name', 'holder_name')->where('is_active', 1)
            ->orderBy('account_name', 'asc')
                ->get();
            return response()->json($data, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function verifyDirectAccounts(Request $request)
    {

        try {
            $data = DirectAccount::select('id', 'account_name', 'company_name', 'holder_name')
            ->where('account_number', $request['account_number'])->where('id', $request['id'])->where('is_active',1)
                          ->firstOrFail();
            return response()->json($data, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
                // dd($request->all());

            $direct_account = new DirectAccount();

            $direct_account->country_id = $request->country_id;
            $direct_account->state_id = $request->state_id;
            $direct_account->city_id = $request->city_id;

            $direct_account->account_number = $request->account_number;
            $direct_account->account_name = $request->account_name;
            $direct_account->holder_name = $request->holder_name;
            $direct_account->holder_phone_no = $request->holder_phone_no;
            $direct_account->holder_mobile_number = $request->holder_mobile_number;
            $direct_account->holders_email = $request->holders_email;
            $direct_account->company_name = $request->company_name;
            $direct_account->cc_number = $request->cc_number;
            $direct_account->csv_code = $request->csv_code;
            $direct_account->cc_expiry = $request->cc_expiry;
            $direct_account->holder_address = $request->holder_address;
            $direct_account->contact_first_name = $request->contact_first_name;
            $direct_account->contact_last_name = $request->contact_last_name;
            $direct_account->contact_phone_number = $request->contact_phone_number;
            $direct_account->contact_email = $request->contact_email;

            $direct_account->save();

            return response()->json(['message' => 'Direct Account saved successfully'], 201);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            $obj = new stdClass();

            $direct_account = DirectAccount::findOrFail($id);

            $obj->direct_account = $direct_account;

            return response()->json($obj);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            $direct_account = DirectAccount::findOrFail($id);

            $direct_account->country_id = $request->country_id;
            $direct_account->state_id = $request->state_id;
            $direct_account->city_id = $request->city_id;

            $direct_account->account_number = $request->account_number;
            $direct_account->account_name = $request->account_name;
            $direct_account->holder_name = $request->holder_name;
            $direct_account->holder_phone_no = $request->holder_phone_no;
            $direct_account->holder_mobile_number = $request->holder_mobile_number;
            $direct_account->holders_email = $request->holders_email;
            $direct_account->company_name = $request->company_name;
            $direct_account->cc_number = $request->cc_number;
            $direct_account->csv_code = $request->csv_code;
            $direct_account->cc_expiry = $request->cc_expiry;
            $direct_account->holder_address = $request->holder_address;
            $direct_account->contact_first_name = $request->contact_first_name;
            $direct_account->contact_last_name = $request->contact_last_name;
            $direct_account->contact_phone_number = $request->contact_phone_number;
            $direct_account->contact_email = $request->contact_email;

            $direct_account->save();

            return response()->json(['message' => 'Direct Account updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function getServerData()
    {
        try {
            $data = DirectAccount::all();

            return response()->json($data, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function updateIsActive(Request $request, $id)
    {
        try {
                DirectAccount::whereId($id)->update([
                'is_active' => $request->status
            ]);

            return response()->json(['message' => 'Account status updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
}
