<?php

namespace App\Http\Controllers\Admin\Customers;

use stdClass;
use App\Models\Module;
use App\Models\Admin\Site;
use App\Models\Admin\User;
use Illuminate\Support\Str;
use App\Models\Admin\Driver;
use Illuminate\Http\Request;
use App\Models\Admin\Vehicle;
use App\Models\Admin\Customer;
use App\Models\Admin\SitesLog;
use Illuminate\Support\Carbon;
use App\Models\Admin\CustomerLog;
use App\Models\Admin\Reservation;
use Illuminate\Support\Facades\DB;
use App\Models\Admin\GuestCustomer;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Route;
use App\Models\Admin\SecurityQuestion;
use App\Models\Admin\ImportCustomerLog;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Password;
use Illuminate\Support\Facades\Validator;
use App\Http\Controllers\Admin\Reservations\ReservationsController;

class CustomersController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function __construct()
    {
        ini_set('max_execution_time', 2000);
    }

    public function index()
    {
        return view('admin.managements.customers.index');
    }

    public function importCustomerPage()
    {
        return view('admin.managements.customers.importCustomer');
    }

    public function exportCustomerPage()
    {
        return view('admin.managements.customers.exportCustomer');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    public function dashboard()
    {
        return view('customer.customers.dashboard');
    }
    public function iFrameCustomerDashboard()
    {
        return view('frontend.iframes.customerDashboard');
    }
    public function iFrameCustomerProfile()
    {
        return view('frontend.iframes.customerProfile');
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // dd($request->all());
        try {
            // $customers_mobile_number_check = Customer::where('mobile_number', $request->mobile_number)->first();
            // $customers_email_check = Customer::where('email', $request->email)->first();

            // if ($customers_mobile_number_check) {
            //     return response()->json(['message' => 'Mobile Number already exist'], 400);
            // } elseif ($customers_email_check) {
            //     return response()->json(['message' => 'Email already exist'], 400);
            // }

            $customer = new Customer();

            $customer->site_id = 1;
            $customer->first_name = $request->first_name;
            $customer->last_name = $request->last_name;
            $customer->phone_number = $request->phone_number;
            $customer->mobile_number = $request->mobile_number;
            $customer->address = $request->address;
            $customer->email = $request->email;
            $customer->readable_password = $request->password;
            $customer->password = bcrypt($request->password);
            $customer->customer_type = 'Registered';
            $customer->status = 'Registered Customer';
            $customer->is_important_info = $request->is_important_info ? $request->is_important_info : 0;
            $customer->is_discount_promotion = $request->is_discount_promotion ? $request->is_discount_promotion : 0;
            $customer->security_question_id = $request->security_question_id;
            $customer->security_answer = $request->security_answer;

            // $customer->card_type = $request->card_type;
            // $customer->cc_number = $request->cc_number;
            // $customer->csv_code = $request->csv_code;
            // $customer->cc_expiry = $request->cc_expiry;
            // $customer->billing_address = $request->billing_address;
            // $customer->billing_zip_code = $request->billing_zip_code;
            // $customer->card_holder_name = $request->card_holder_name;
            // $customer->billing_phone_number = $request->billing_phone_number;
            // $customer->is_address_same = $request->is_address_same ? $request->is_address_same : 0;
            // if ($request->is_address_same == 1) {
            //     $customer->billing_address = $request->address;
            //     $customer->billing_phone_number = $request->phone_number;
            // }

            $customer->save();
            return response()->json(['message' => 'Wait! For login '], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function apiStore(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'token' => 'required',
            ]);
            if ($validator->fails()) {
                return response()->json(['errors' => $validator->errors()], 400);
            } else {
                $sites = siteVerification($request->token);

                $sitesId = Site::where('token', $request->token)->pluck('id')->first();

                if ($sites) {
                    $validator = Validator::make($request->all(), [
                        'first_name' => 'required',
                        'last_name' => 'required',
                        'mobile_number' => 'required',
                        'phone_number' => 'required',
                        'address' => 'required',
                        'email' => 'required',
                        'password' => 'required',
                        'card_type' => 'required',
                        'cc_number' => 'required',
                        'cc_expiry' => 'required',
                        'billing_zip_code' => 'required',
                        'card_holder_name' => 'required',
                    ]);

                    if ($validator->fails()) {
                        return response()->json(['errors' => $validator->errors()], 400);
                    } else {
                        $customers_phone_number_check = Customer::where('phone_number', $request->phone_number)->first();
                        $customers_mobile_number_check = Customer::where('mobile_number', $request->mobile_number)->first();
                        $customers_email_check = Customer::where('email', $request->email)->first();

                        if ($customers_phone_number_check) {
                            return response()->json(['message' => 'Phone Number already exist'], 400);
                        } elseif ($customers_mobile_number_check) {
                            return response()->json(['message' => 'Mobile Number already exist'], 400);
                        } elseif ($customers_email_check) {
                            return response()->json(['message' => 'Email already exist'], 400);
                        }

                        $customer = new Customer();
                        $customer->site_id = $sitesId;
                        $customer->first_name = $request->first_name;
                        $customer->last_name = $request->last_name;
                        $customer->phone_number = $request->phone_number;
                        $customer->mobile_number = $request->mobile_number;
                        $customer->address = $request->address;
                        $customer->email = $request->email;
                        $customer->password = bcrypt($request->password);
                        $customer->readable_password = $request->password;
                        $customer->customer_type = 'Registered';
                        $customer->status = 'Registered Customer';
                        $customer->card_type = $request->card_type;
                        $customer->cc_number = $request->cc_number;
                        $customer->csv_code = $request->csv_code;
                        $customer->cc_expiry = $request->cc_expiry;
                        $customer->billing_address = $request->billing_address;
                        $customer->billing_zip_code = $request->billing_zip_code;
                        $customer->card_holder_name = $request->card_holder_name;
                        $customer->billing_phone_number = $request->billing_phone_number;
                        $customer->is_important_info = $request->is_important_info ? $request->is_important_info : 0;
                        $customer->is_address_same = $request->is_address_same ? $request->is_address_same : 0;
                        $customer->is_discount_promotion = $request->is_discount_promotion ? $request->is_discount_promotion : 0;
                        if ($request->is_address_same == 1) {
                            $customer->billing_address = $request->address;
                            $customer->billing_phone_number = $request->phone_number;
                        }

                        $customer->save();

                        $existingSiteLog = SitesLog::where('token', $request->token)->first();

                        if ($existingSiteLog) {
                            // Token already exists, increment the calls_count
                            $existingSiteLog->calls_count++;
                            $existingSiteLog->save();
                            $count = $existingSiteLog->calls_count;
                        } else {
                            // Token doesn't exist, create a new entry
                            $sites_log_data = new SitesLog();
                            $sites_log_data->site_id = $sitesId;
                            $sites_log_data->site_url = $request->getSchemeAndHttpHost();
                            $sites_log_data->token = $request->token;
                            $sites_log_data->ip_address = $request->ip();
                            $sites_log_data->calls_count = 1; // Initialize calls_count to 1 for the first call
                            $sites_log_data->save();
                        }
                        return response()->json(['message' => 'Registration successful'], 201);
                    }
                } else {
                    return response()->json(['message' => ' Sites Verification Problem. Check Your token'], 401);
                }
            }
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id, $customerType)
    {
        // dd($customerType);
        try {
            $obj = new stdClass();
            // if ($customerType == 'Registered' || $customerType == 'registered') {
            $customer = Customer::findOrFail($id);
            $obj->customer = $customer;
            // } else if ($customerType == 'Guest' || $customerType == 'guest') {
            //     $customer = GuestCustomer::findOrFail($id);
            //     $obj->customer = $customer;
            // }
            return response()->json($obj);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id, $customerType)
    {
        try {
            $customer = Customer::findOrFail($id);

            $customer->first_name = $request->first_name;
            $customer->last_name = $request->last_name;
            $customer->phone_number = $request->phone_number;
            $customer->mobile_number = $request->mobile_number;
            $customer->email = $request->email;
            $customer->address = $request->address;
            $customer->customer_type = $customerType;
            // $customer->card_type = $request->card_type;
            // $customer->cc_number = $request->cc_number;
            // $customer->cc_expiry = $request->cc_expiry;
            // $customer->csv_code = $request->csv_code;
            // $customer->billing_zip_code = $request->billing_zip_code;
            // $customer->billing_address = $request->billing_address;
            // $customer->card_holder_name = $request->card_holder_name;
            $customer->is_important_info = $request->is_important_info ? $request->is_important_info : 0;
            $customer->is_discount_promotion = $request->is_discount_promotion ? $request->is_discount_promotion : 0;
            // if (isset($request->billing_address)) {
            //     $customer->billing_address = $request->billing_address;
            // }
            // $customer->billing_phone_number = $request->billing_phone_number;

            $customer->save();
            return response()->json(['message' => 'Customer update successfully','customer' => $customer], 201);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {

        $customer = Customer::findOrFail($id);

        $reservations = Reservation::where('customer_id', $id)->get();
        foreach ($reservations as $reservation) {
            $reservation->delete();
        }

        $customer->delete();

        return response()->json(['message' => 'Customer and Reservation Deleted Successfully']);
    }

    public function getCustomerInfo($customerId, $customerType)
    {
        try {
            // dd($customerId);

            $obj = new stdClass();

            if ($customerType == 'registered' || $customerType == 'Registered') {
                $customer = Customer::where('id', $customerId)
                    ->first();
            } else {
                $customer = GuestCustomer::where('id', $customerId)
                    ->first();
            }
            $obj->customer = $customer;

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getAllReservationInfo()
    {
        try {
            $obj = new stdClass();

            $vehicles = Vehicle::select('id', 'vehicles_type')->get();

            $obj->vehicles = $vehicles;

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getCustomerAllReservations(Request $request)
    {
        try {
            $customerId = Auth::id();
            if ($request->search_type === 'my_rides')  $request->merge(['start_date' => Carbon::today()->toDateString()]);
            $request->merge(['customer_id' => $customerId]);
            $customerReservations = json_decode(ReservationsController::searchReservations($request)->content(), true);

            return response()->json(["reservations" => $customerReservations, "sDate" => Carbon::today()->toDateString()], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getDateRangeReservations(Request $request)
    {
        try {
            $obj = new stdClass();

            $customerId = Auth::id();
            $obj->dateRangeReservations = Reservation::where('customer_id', $customerId)
                ->where(function ($query) {
                    $query->where('customer_type', 'registered')
                        ->orWhere('customer_type', 'Registered');
                })
                ->whereDate('created_at', '>=', $request->start_date)
                ->whereDate('updated_at', '<=', $request->ending_date)
                ->get();

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function logout()
    {
        Auth::guard('customer')->logout();
        return redirect()->route('index')->with('message', 'Logout Successfully');
    }

    public function getCustomersData()
    {
        try {
            $obj = new stdClass();

            // Get all registered customers with their reservations count
            $allCustomer = Customer::select('id', 'first_name', 'last_name', 'address', 'billing_address', 'notes', 'pay_type_id', 'card_type', 'cc_number', 'cc_expiry', 'phone_number', 'mobile_number', 'email', 'is_active')
                ->withCount(['reservations' => function ($query) {
                    $query->where('customer_type', 'registered')
                        ->orWhere('customer_type', 'Registered');
                }])
                ->get();

            // Get all guest customers with their reservations count
            // $allGuestCustomers = GuestCustomer::select('id', 'first_name', 'last_name', 'address', 'phone_number', 'mobile_number', 'email', 'is_active')
            //     ->withCount(['reservations' => function ($query) {
            //         $query->where('customer_type', 'guest')
            //             ->orWhere('customer_type', 'Guest');
            //     }])
            //     ->get();

            $obj->allCustomer = $allCustomer;
            //$obj->allGuestCustomers = $allGuestCustomers;

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function getBadgesData()
    {
        try {
            $customers = Customer::where(function ($q) {
                $q->where('customer_type', 'Registered')
                    ->orWhere('customer_type', 'registered');
            })->count();
            $guestCustomers = Customer::where(function ($q) {
                $q->where('customer_type', 'Guest')
                    ->orWhere('customer_type', 'guest');
            })->count();


            $badgesData = [
                'customers_count' => $customers,
                'guest_customer_count' => $guestCustomers,
            ];
            return response()->json($badgesData, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    //working fine
    // public function getSearchedCustomers(Request $request)
    // {
    //     dd($request->all());
    //     try {
    //         $obj = new stdClass();
    //         $searchType = $request->searchType;
    //         $searchValue = $request->searchCustomer;
    //         $columns = ['id', 'first_name', 'last_name', 'address', 'billing_address', 'notes', 'pay_type_id','card_type', 'cc_expiry', 'cc_status', 'cc_number', 'phone_number', 'mobile_number', 'email', 'is_active','customer_type'];
    //         $baseQuery = Customer::select($columns)
    //         ->whereDate('created_at', '>=', $request->start_date)
    //         ->whereDate('updated_at', '<=', $request->ending_date)
    //         ->withCount(['reservations']);

    //         $query = (clone $baseQuery)->where(function($q) {
    //             $q->where('customer_type', 'Registered')
    //             ->orWhere('customer_type', 'registered');
    //         });

    //         $guestQuery = (clone $baseQuery)->where(function($q) {
    //             $q->where('customer_type', 'Guest')
    //             ->orWhere('customer_type', 'guest');
    //         });

    //         if ($searchType == 'new_customer') {
    //             $obj->allCustomer =$query ->having('reservations_count', '=', 1)->get();
    //             $obj->allGuestCustomers =$query->having('reservations_count', '=', 1)->get();

    //         }
    //         else if ($searchType == 'repeated_customer') {

    //             $obj->allCustomer =$query->having('reservations_count', '>', 1)->get();
    //             $obj->allGuestCustomers =$guestQuery ->having('reservations_count', '>', 1)->get();
    //         }
    //         else if($searchType == 'all_customers'){
    //             $obj->allCustomer =$query->get();
    //             $obj->allGuestCustomers = $guestQuery->get();
    //         }
    //         else{
    //             $obj->allCustomer = $query->where($searchType,'LIKE', '%'. $searchValue . '%')->get();
    //             $obj->allGuestCustomers = $guestQuery->where($searchType,'LIKE', '%'. $searchValue . '%')->get();
    //         }

    //         //     $allCustomer = Customer::select($columns)
    //         //     ->where(function ($query) use ($searchType, $searchValue) {
    //         //         if ($searchType == 'last_4_digit') {
    //         //             // Search by last 4 digits of cc_number
    //         //             $query->whereRaw("RIGHT(cc_number, 4) = ?", [$searchValue]);
    //         //         } else {
    //         //             // Search by other criteria (e.g., first_name, last_name, etc.)
    //         //             $query->where($searchType, '=', $searchValue);
    //         //         }
    //         //     })
    //         //     ->withCount(['reservations' => function ($query) {
    //         //         $query->where('customer_type', 'registered')
    //         //             ->orWhere('customer_type', 'Registered');
    //         //     }])
    //         //     ->get();

    //         //     if ($searchType == 'last_4_digit' || $searchType == 'cc_number') {
    //         //         $obj->allGuestCustomers = [];
    //         //     } else {
    //         //     // Get all guest customers with their reservations count
    //         //     $allGuestCustomers = GuestCustomer::select($columns)
    //         //         ->where($searchType, '=', $searchValue)
    //         //         ->withCount(['reservations' => function ($query) {
    //         //             $query->where('customer_type', 'guest')
    //         //                 ->orWhere('customer_type', 'Guest');
    //         //         }])
    //         //         ->get();
    //         //     $obj->allGuestCustomers = $allGuestCustomers;
    //         // }
    //         // $obj->allCustomer = $allCustomer;
    //         // }
    //         return response()->json($obj, 200);
    //     } catch (\Exception $exception) {
    //         return response()->json(['error' => $exception->getMessage()], 500);
    //     }
    // }
    public function getSearchedCustomers(Request $request)
    {
        try {
            $fromReservation = $request->query('reservations') === 'true' ? 1 : 0;
            $searchType = $request->searchType;
            $searchValue = $request->searchCustomer;
            $searchCustomerType = $request->searchCustomerType;
            $isExport = $request->isExport;
            $columns = ['id', 'first_name','last_name', 'address', 'billing_address', 'notes', 'pay_type_id', 'card_type', 'cc_expiry', 'cc_status', 'csv_code', 'billing_zip_code', 'card_holder_name', 'billing_address', 'billing_phone_number', 'is_address_same', 'cc_number', 'phone_number', 'mobile_number', 'email', 'is_active', 'customer_type', 'status', 'reservations_count'];
            $query = Customer::select($columns)
                ->where(function ($q) use ($searchCustomerType) {
                    if ($searchCustomerType != 'all_customers') {
                        $q->where('customer_type', $searchCustomerType)
                            ->orWhere('customer_type', strtolower($searchCustomerType));
                    }
                })
                ->withCount(['reservations as total_reservations']);
            switch ($searchType) {
                case 'new_customer':
                    $query->whereDate('created_at', '>=', $request->start_date)
                        ->whereDate('updated_at', '<=', $request->ending_date)
                        ->having('reservations_count', '=', 1);
                    break;

                case 'repeated_customer':
                    $query->having('reservations_count', '>', 1);
                    break;

                case 'first_name' || 'last_name' || 'phone_number' || 'mobile_number':
                    $query->where($searchType, 'LIKE', '%' . $searchValue . '%');
                    break;

                default:
                    // No additional filters needed for all_customers
                    break;
            }

            $customer = $isExport || $fromReservation ?  $query->get() : $query->paginate(100);
            return response()->json($customer, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    // public function getSearchedCustomers(Request $request)
    // {
    //     dd($request->all());
    //     try {
    //         $obj = new stdClass();
    //         $searchType = $request->searchType;
    //         $searchValue = $request->searchCustomer;
    //         $columns = ['id', 'first_name', 'last_name', 'address', 'billing_address', 'notes', 'pay_type_id','card_type', 'cc_expiry', 'cc_status', DB::raw("RIGHT(cc_number, 4) AS cc_number"), 'phone_number', 'mobile_number', 'email', 'is_active','customer_type'];
    //         if ($searchType == 'new_customer') {
    //             $allCustomer = Customer::select($columns)
    //                 ->whereDate('created_at', '>=', $request->start_date)
    //                 ->whereDate('updated_at', '<=', $request->ending_date)
    //                 ->withCount(['reservations' => function ($query) {
    //                     $query->where('customer_type', 'Registered')
    //                         ->orWhere('customer_type', 'registered');
    //                 }])
    //                 ->having('reservations_count', '=', 1) // Add this condition
    //                 ->get();
    //              $obj->allCustomer = $allCustomer;
    //             // $allGuestCustomers = GuestCustomer::select('id', 'first_name', 'last_name', 'address', 'billing_address', 'notes', 'cc_number', 'phone_number', 'mobile_number', 'email', 'is_active')
    //             //     ->whereDate('created_at', '>=', $request->start_date)
    //             //     ->whereDate('updated_at', '<=', $request->ending_date)
    //             //     ->withCount(['reservations' => function ($query) {
    //             //         $query->where('customer_type', 'Guest')
    //             //             ->orWhere('customer_type', 'guest');
    //             //     }])
    //             //     ->having('reservations_count', '=', 1) // Add this condition
    //             //     ->get();
    //             // $obj->allGuestCustomers = $allGuestCustomers;
    //             // dd($guestCustomer);
    //         }
    //         else if ($searchType == 'repeated_customer') {
    //             $allCustomer = Customer::select($columns)
    //                 ->whereDate('created_at', '>=', $request->start_date)
    //                 ->whereDate('updated_at', '<=', $request->ending_date)
    //                 ->withCount(['reservations' => function ($query) {
    //                     $query->where('customer_type', 'Registered')
    //                         ->orWhere('customer_type', 'registered');
    //                 }])
    //                 ->having('reservations_count', '>', 1) // Add this condition
    //                 ->get();
    //             $obj->allCustomer = $allCustomer;
    //             $allGuestCustomers = GuestCustomer::select($columns)
    //                 ->whereDate('created_at', '>=', $request->start_date)
    //                 ->whereDate('updated_at', '<=', $request->ending_date)
    //                 ->withCount(['reservations' => function ($query) {
    //                     $query->where('customer_type', 'Guest')
    //                         ->orWhere('customer_type', 'guest');
    //                 }])
    //                 ->having('reservations_count', '>', 1) // Add this condition
    //                 ->get();
    //             $obj->allGuestCustomers = $allGuestCustomers;
    //             // dd($guestCustomer);
    //         }
    //         else if($searchType == 'all_customers'){
    //             $allCustomer = Customer::select($columns)
    //             ->whereDate('created_at', '>=', $request->start_date)
    //             ->whereDate('updated_at', '<=', $request->ending_date)
    //             ->withCount(['reservations' => function ($query) {
    //                 $query->where('customer_type', 'registered')
    //                     ->orWhere('customer_type', 'Registered');
    //             }])
    //             ->get();
    //             $obj->allCustomer = $allCustomer;

    //             $allGuestCustomers = GuestCustomer::select($columns)
    //                 ->whereDate('created_at', '>=', $request->start_date)
    //                 ->whereDate('updated_at', '<=', $request->ending_date)
    //                 ->withCount(['reservations' => function ($query) {
    //                     $query->where('customer_type', 'guest')
    //                         ->orWhere('customer_type', 'Guest');
    //                 }])
    //                 ->get();
    //             $obj->allGuestCustomers = $allGuestCustomers;
    //         }
    //         else{
    //             $allCustomer = Customer::select($columns)
    //             ->where(function ($query) use ($searchType, $searchValue) {
    //                 if ($searchType == 'last_4_digit') {
    //                     // Search by last 4 digits of cc_number
    //                     $query->whereRaw("RIGHT(cc_number, 4) = ?", [$searchValue]);
    //                 } else {
    //                     // Search by other criteria (e.g., first_name, last_name, etc.)
    //                     $query->where($searchType, '=', $searchValue);
    //                 }
    //             })
    //             ->withCount(['reservations' => function ($query) {
    //                 $query->where('customer_type', 'registered')
    //                     ->orWhere('customer_type', 'Registered');
    //             }])
    //             ->get();

    //             if ($searchType == 'last_4_digit' || $searchType == 'cc_number') {
    //                 $obj->allGuestCustomers = [];
    //             } else {
    //             // Get all guest customers with their reservations count
    //             $allGuestCustomers = GuestCustomer::select($columns)
    //                 ->where($searchType, '=', $searchValue)
    //                 ->withCount(['reservations' => function ($query) {
    //                     $query->where('customer_type', 'guest')
    //                         ->orWhere('customer_type', 'Guest');
    //                 }])
    //                 ->get();
    //             $obj->allGuestCustomers = $allGuestCustomers;
    //         }
    //         $obj->allCustomer = $allCustomer;
    //         }
    //         return response()->json($obj, 200);
    //     } catch (\Exception $exception) {
    //         return response()->json(['error' => $exception->getMessage()], 500);
    //     }
    // }

    public function getCustomerReservations(Request $request)
    {
        try {
            $obj = new stdClass();

            $baseQuery = Reservation::where('customer_id', $request->customerId);

            $obj->reservations = $baseQuery->get();
            foreach ($obj->reservations as $reservation) {
                $reservation->customer = Customer::find($reservation->customer_id);
            }

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getCustomerNotes(Request $request)
    {
        // dd('here');
        try {
            if ($request->customer_type == 'Registered' || $request->customer_type == 'registered') {
                $customer_notes = Customer::select('id', 'notes')->whereId($request->customer_id)->pluck('notes')->first();
            }
            if ($request->customer_type == 'Guest' || $request->customer_type == 'guest') {
                $customer_notes = GuestCustomer::select('id', 'notes')->whereId($request->customer_id)->pluck('notes')->first();
            }
            return response()->json($customer_notes, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function registerCustomer(Request $request)
    {
        dd($request->all());
    }

    public function updateCustomerIsActive(Request $request, $id)
    {
        try {

            $latestTokenId = DB::table('oauth_access_tokens')
                ->where('user_id', $id)
                ->orderBy('created_at', 'desc')
                ->value('id');

            // Check if a token was found and update the revoked status
            if ($latestTokenId) {
                DB::table('oauth_access_tokens')
                    ->where('id', $latestTokenId)
                    ->update(['revoked' => !$request->status]);
            }


            Customer::whereId($id)->update([
                'is_active' => $request->status,
                'block_reason' => $request->reason?$request->reason:null
            ]);

            return response()->json(['message' => 'Customer Status updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function updateGuestCustomerIsActive(Request $request, $id)
    {
        try {
            GuestCustomer::whereId($id)->update([
                'is_active' => $request->status
            ]);

            return response()->json(['message' => 'Customer Status updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }


    public function apiLogin(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'token' => 'required',
            ]);
            if ($validator->fails()) {
                return response()->json(['errors' => $validator->errors()], 400);
            } else {
                $sites = siteVerification($request->token);

                $sitesId = Site::where('token', $request->token)->pluck('id')->first();
                if ($sites) {
                    // Validate the incoming request
                    $validator = Validator::make($request->all(), [
                        'email' => 'required',
                        'password' => 'required',
                    ]);

                    if ($validator->fails()) {
                        return response()->json(['errors' => $validator->errors()], 400);
                    } else {

                        // Get the customer with the provided email
                        $customer = Customer::where('email', $request->email)->first();

                        // If the customer doesn't exist or the password doesn't match, return an error response
                        if (!$customer || !Hash::check($request->password, $customer->password)) {
                            return response()->json(['message' => 'Invalid credentials'], 401);
                        }

                        $md5Data = md5($request->email . $sitesId  . $customer->created_at);

                        $existingCustomerLog = CustomerLog::where('token', $md5Data)->first();

                        if ($existingCustomerLog) {
                            // Token already exists, increment the calls_count
                            $existingCustomerLog->calls_count++;
                            $existingCustomerLog->save();
                            $count = $existingCustomerLog->calls_count;
                        } else {
                            // Token doesn't exist, create a new entry
                            $customers_log_data = new CustomerLog();
                            $customers_log_data->site_id = $sitesId;
                            $customers_log_data->site_url = $request->getSchemeAndHttpHost();
                            $customers_log_data->token = $md5Data;
                            $customers_log_data->ip_address = $request->ip();
                            $customers_log_data->calls_count = 1; // Initialize calls_count to 1 for the first call
                            $customers_log_data->save();
                        }

                        // Return a success response with the customer data or token if needed
                        return response()->json(['message' => 'Login successful', 'customers_token' => $md5Data], 200);
                    }
                } else {
                    return response()->json(['message' => ' Sites Verification Problem. Check Your token'], 401);
                }
            }
        } catch (\Exception $exception) {
            return response()->json(['error' => $request], 401);
        }
    }

    public function getDateRangeCustomers(Request $request)
    {
        try {
            $searchType = $request->search_type_date;
            $obj = new stdClass();
            if ($searchType == 'new_customer') {
                $allCustomer = Customer::select('id', 'first_name', 'last_name', 'address', 'billing_address', 'notes', 'cc_number', 'phone_number', 'mobile_number', 'email', 'is_active')
                    ->whereDate('created_at', '>=', $request->start_date)
                    ->whereDate('updated_at', '<=', $request->ending_date)
                    ->withCount(['reservations' => function ($query) {
                        $query->where('customer_type', 'Registered')
                            ->orWhere('customer_type', 'registered');
                    }])
                    ->having('reservations_count', '=', 1) // Add this condition
                    ->get();
                $obj->allCustomer = $allCustomer;
                $allGuestCustomers = GuestCustomer::select('id', 'first_name', 'last_name', 'address', 'billing_address', 'notes', 'cc_number', 'phone_number', 'mobile_number', 'email', 'is_active')
                    ->whereDate('created_at', '>=', $request->start_date)
                    ->whereDate('updated_at', '<=', $request->ending_date)
                    ->withCount(['reservations' => function ($query) {
                        $query->where('customer_type', 'Guest')
                            ->orWhere('customer_type', 'guest');
                    }])
                    ->having('reservations_count', '=', 1) // Add this condition
                    ->get();
                $obj->allGuestCustomers = $allGuestCustomers;
                // dd($guestCustomer);
            } else if ($searchType == 'repeated_customer') {
                $allCustomer = Customer::select('id', 'first_name', 'last_name', 'address', 'billing_address', 'notes', 'cc_number', 'phone_number', 'mobile_number', 'email', 'is_active')
                    ->whereDate('created_at', '>=', $request->start_date)
                    ->whereDate('updated_at', '<=', $request->ending_date)
                    ->withCount(['reservations' => function ($query) {
                        $query->where('customer_type', 'Registered')
                            ->orWhere('customer_type', 'registered');
                    }])
                    ->having('reservations_count', '>', 1) // Add this condition
                    ->get();
                $obj->allCustomer = $allCustomer;
                $allGuestCustomers = GuestCustomer::select('id', 'first_name', 'last_name', 'address', 'billing_address', 'notes', 'cc_number', 'phone_number', 'mobile_number', 'email', 'is_active')
                    ->whereDate('created_at', '>=', $request->start_date)
                    ->whereDate('updated_at', '<=', $request->ending_date)
                    ->withCount(['reservations' => function ($query) {
                        $query->where('customer_type', 'Guest')
                            ->orWhere('customer_type', 'guest');
                    }])
                    ->having('reservations_count', '>', 1) // Add this condition
                    ->get();
                $obj->allGuestCustomers = $allGuestCustomers;
                // dd($guestCustomer);
            }
            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getSecurityQuestion()
    {
        // dd('here');
        try {
            $securityQuestions = SecurityQuestion::select('id', 'name')
                ->orderBy('name', 'ASC')
                ->get();
            // dd($securityQuestions);
            return response()->json($securityQuestions, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function customerEmailAuthentication(Request $request)
    {
        try {
            // Validate the email input
            $validator = Validator::make($request->all(), [
                'email' => 'required|email',
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'status' => false,
                    'message' => $validator->errors()->all(),
                ]);
            }

            // Attempt to send the reset link
            $status = Password::sendResetLink($request->only('email'));

            return response()->json([
                'status' => $status === Password::RESET_LINK_SENT,
                'message' => __($status),
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'status' => false,
                'message' => 'Contact to ',
                'error' => $exception->getMessage()
            ]);
        }
    }


    public function checkCustomerSecurityAnswer(Request $request)
    {
        try {
            $customer = Customer::where('email', $request->email)
                ->where('security_answer', $request->security_answer)
                ->first();

            if ($customer) {
                return response()->json(['is_valid' => true]);
            }
            return response()->json('false');
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function updatePassword(Request $request)
    {

        // dd($request->all());
        try {
            $customer = Customer::where('email', $request->email)
                ->where('security_answer', $request->security_answer)
                ->first();

            if ($customer) {
                $customer->readable_password = $request->password;
                $customer->password = bcrypt($request->password);
                $customer->save();
                return response()->json(['message' => 'Update Password successfully'], 200);
            }
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function checkCustomerEmail(Request $request)
    {
        try {
            // dd($request->all());
            if ($request->email) {
                if (Customer::where('email', '=', $request->email)
                    ->first()
                ) {
                    return response()->json(['isAvailable' => 'no']);
                } else {
                    return response()->json(['isAvailable' => 'yes']);
                }
            } else {
                return response()->json(['isAvailable' => 'empty']);
            }
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function getCustomerPassword($customerId)
    {
        try {
            // dd($request->all());
            $query = "SELECT  readable_password FROM customers WHERE id = ?";
            $password = DB::select($query, [$customerId]);
            //  dd($password);
            if (count($password) > 0) {
                // Password found for the specified customer_id
                return response()->json([
                    'password' => $password[0]->readable_password
                ]);
            } else {
                // No password found for the specified customer_id
                return response()->json(['message' => 'Password not found'], 404);
            }
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function adminUpdateCustomerPassword(Request $request)
    {
        // dd($request->all());
        try {
            $customer = Customer::findOrFail($request->customer_id);
            // dd($customer);
            if ($customer) {
                $customer->readable_password = $request->password;
                $customer->password = bcrypt($request->password);
                $customer->save();
                return response()->json(['message' => 'Update Password successfully'], 200);
            }
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function getAdminAuthentication()
    {
        if (Auth::user()->role_id == 1) {
            return response()->json(['isAdmin' => 'yes']);
        } else {
            return response()->json(['isAdmin' => 'no']);
        }
    }
    public function checkCustomerPassword(Request $request)
    {
        try {
            // dd($request->all());
            $customer = Customer::where('id', $request->customer_id)->first();

            if ($customer && Hash::check($request->old_password, $customer->password)) {
                return response()->json(true);
            } else {
                return response()->json(false);
            }
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function updateCustomerPassword(Request $request)
    {
        try {
            $customer = Customer::findOrFail($request->customer_id);
            // dd($customer);
            if ($customer) {
                $customer->readable_password = $request->password;
                $customer->password = bcrypt($request->password);
                $customer->save();
                return response()->json(['message' => 'Update Password successfully'], 200);
            }
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function apiCustomerLogout(Request $request)
    {
        $request->user()->token()->revoke();

        return response()->json(['message' => 'Successfully logged out', 'logout' => true]);
    }

    public function importCustomers(Request $request)
    {

        $insertedCount = 0;
        DB::beginTransaction();
        try {

            $data = $request->all();
            $insertData = [];
            foreach ($data as $row) {
                // Map the Excel sheet data to the database columns
                $address = [];
                $addressComponents = [];

                if (!empty($row['ADDRESS'])) {
                    $address['address'] = $row['ADDRESS'];
                    $address['description'] = $row['ADDRESS'];
                    // $addressComponents[] = $row['ADDRESS'];
                }
                // if (!empty($row['CITY'])) {
                //     $address['city'] = $row['CITY'];
                //     $addressComponents[] = $row['CITY'];
                // }
                // if (!empty($row['STATE'])) {
                //     $address['state'] = $row['STATE'];
                //     $addressComponents[] = $row['STATE'];
                // }
                // if (!empty($row['ZIPCODE'])) {
                //     $address['postcode'] = $row['ZIPCODE'];
                // }
                // $addressDescription = implode(', ', $addressComponents);
                // $address['description'] = $addressDescription;

                $customerData = [
                    'first_name' => $row['FIRST NAME'] ?? null,
                    'last_name' => $row['LAST NAME'] ?? null,
                    'email' => $row['EMAIL'] ?? null,
                    'address' => json_encode($address) ?? null,
                    'phone_number' => $row['HOME PHONE'] ?? null,
                    'mobile_number' => $row['CELL PHONE'] ?? null,
                    'work_phone' => $row['WORK PHONE'] ?? null,
                    'reservations_count' => $row['RESERVATIONS'] ?? null,
                    'cancelled_count' => $row['CANCELED'] ?? null,
                    'no_show_count' => $row['NO SHOW'] ?? null,
                    'completed_count' => $row['COMPLETED'] ?? null,
                    'customer_type' => 'Registered'
                ];
                $insertData[] = $customerData;
                $insertedCount++;
            }

            // dd($insertData);
            // Batch insert
            if (!empty($insertData)) {
                Customer::insert($insertData);
            }

            // Batch update (use a package or raw queries for this)

            DB::commit();
            return response()->json([
                'message' => 'Customers imported successfully',
                'inserted_count' => $insertedCount
            ]);
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json(['error' => 'Error importing customers', 'message' => $e->getMessage()], 500);
        }
    }

    public function exportCustomers($type)
    {
        // dd($type);
        if ($type == 1) {
            $customer = DB::table('customers')->select('phone_number',  'first_name', 'last_name')->whereNotNull('phone_number')->orderBy('created_at', 'ASC')->get();
        } else if ($type == 2) {
            $customer = DB::table('customers')->select('mobile_number', 'first_name', 'last_name')->whereNotNull('mobile_number')->orderBy('created_at', 'ASC')->get();
        } else {
            $customer =  DB::table('customers')->select('email', 'first_name', 'last_name')->whereNotNull('email')->orderBy('created_at', 'ASC')->get();
        }
        return response()->json($customer, 200);
    }
}
