<?php

namespace App\Http\Controllers\Admin;

use stdClass;
use App\Models\Admin\City;
use App\Models\Admin\State;
use App\Models\Admin\Coupon;
use Illuminate\Http\Request;
use App\Models\Admin\Vehicle;
use App\Models\Admin\Services;
use App\Models\Admin\VehicleMake;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class CouponsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $coupons = Coupon::all();

        return view('admin.coupons.index', [
            'coupons' => $coupons
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            DB::beginTransaction();
            $coupon = new Coupon();

            $coupon->user_id = Auth::id();
            $coupon->city_id = $request->city_id;
            $coupon->service_id = $request->service_id;
            $coupon->coupon_code = $request->coupon_code;
            $coupon->vehicle_make_ids = $request->vehicle_make_ids;
            $coupon->coupon_type = $request->coupon_type;
            $coupon->coupon_price = $request->coupon_price;
            $coupon->expiry_date = $request->expiry_date;

            $coupon->save();

            DB::commit();
            return response()->json(['message' => 'Coupon added successfully'], 201);

        } catch (\Exception $exception) {
            DB::rollback();
            return response()->json(['error' => $exception->getMessage()], 500);
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            // coupon
            $obj = new stdClass();

            $coupon = Coupon::with('city.state.country')->findOrFail($id);

            $obj->coupon = $coupon;

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            DB::beginTransaction();

            $coupon = Coupon::findOrFail($id);

            $coupon->service_id = $request->service_id;
            $coupon->coupon_code = $request->coupon_code;
            $coupon->vehicle_make_ids = $request->vehicle_make_ids;
            $coupon->coupon_type = $request->coupon_type;
            $coupon->coupon_price = $request->coupon_price;
            $coupon->expiry_date = $request->expiry_date;

            $coupon->save();

            DB::commit();
            return response()->json(['message' => 'Coupon updated successfully'], 200);
        } catch (\Exception $exception) {
            DB::rollback();
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    public function updateIsActive(Request $request, $id)
    {
        try {
            Coupon::whereId($id)->update([
                'is_active' => $request->status
            ]);

            return response()->json(['message' => 'Coupon status updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getVehicles($cityId)
    {
        try {
            $obj = new stdClass();
            $obj->allVehicles = Vehicle::select('id','vehicles_type')->where('is_active', 1)->get();

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getData($cityId)
    {
        try {
            $obj = new stdClass();

            $data = Coupon::select('id', 'city_id', 'service_id', 'coupon_code', 'vehicle_make_ids', 'coupon_type', 'coupon_price','expiry_date' ,'is_active')
                ->with(['service' => function ($q) {
                    $q->select('id', 'service_name');
                }])
                ->where('city_id', $cityId)->get();

            // $data = Vehicle::select('id')
            // ->with('coupons')->get();

            $obj->data = $data;

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getServicesData(){

        try {
            $obj = new stdClass();

            $allServices = Services::select('id', 'service_name', 'is_active')->get();

            $obj->allServices = $allServices;

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    private function getCityByLocationAddress($stateName, $cityName)
    {

        if (isset($cityName) && isset($stateName)) {

            $state = State::select('id')->where('name', $stateName)->pluck('id')->first();

            $city = City::select('id', 'name', 'is_active')->where('state_id', $state)
                ->where('name', $cityName)
                ->first();

            return $city;
        } else {
            return false;
        }
    }

    public function validateCoupon(Request $request)
    {
        try{
            if (isset($request['location_object'])) {
                $state = State::select('id')->where('name', $request['location_object']['state'])->pluck('id')->first();
                $city_id = City::select('id')->where('state_id', $state)->where('name', $request['location_object']['city'])->pluck('id')->first();
            }
            $vehicleTypeId = $request['vehicle_type_id'];
            $coupon = Coupon::select('id','coupon_code' ,'coupon_type', 'coupon_price', 'expiry_date')
            ->where('coupon_code', $request['coupon_code'])
                ->where('city_id', $city_id)
                ->where('service_id', $request['service_type_id']) //Add where clause fro checking service type e.g Airport, Hourly etc
                ->whereJsonContains('vehicle_make_ids', $vehicleTypeId) // Add whereJsonContains clause for vehicle type
                ->where('expiry_date', '>=', $request['pick_up_date']) // Add whereDate clause to check expiry date with pickup date
                ->where('is_active', 1)
                ->firstOrFail();
            
            
                return response()->json($coupon, 200);
            
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

}
