<?php

namespace App\Http\Controllers\Admin\Country;

use stdClass;
use GuzzleHttp\Client;
use App\Models\Admin\State;
use Illuminate\Http\Request;
use App\Models\Admin\Country;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;

class CountryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $countries = Country::select('id', 'name', 'iso_2', 'iso_3', 'is_active')->orderby('name', 'ASC')->get();

        return view('admin.countries.index', [
            'countries' => $countries
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            DB::beginTransaction();

            $country = new Country();

            $country->name = $request->name;
            $country->iso_2 = $request->iso_2;
            $country->iso_3 = $request->iso_3;

            $country->save();

        // storeAllStatesOfSpecificCountry($request->country_name, 24);

            // storeAllCitiesOfSpecificCountry($request->country_name, $country->id);

            DB::commit();
            return response()->json(['message' => 'Country added successfully'], 201);
        } catch (\Exception $exception) {
            DB::rollback();
            return response()->json(['error' => $exception->getMessage()], 500);
        }
        // try {
        //     dd($request->country, 'from method');
        //     storeAllCitiesOfSpecificCountry('India', 5);
        //     $response = Http::get('https://restcountries.com/v3.1/all');

        //     return $response;
        //     $countriesArr = array();

        //     foreach (json_decode($response) as $country) {
        //         $countriesArr[] = [
        //             'name' => $country->name->common,
        //             'iso_2' => $country->cca2,
        //             'iso_3' => $country->cca3,
        //             'flag' => $country->flags->png,
        //         ];
        //     }

        //     Country::truncate();
        //     Country::insert($countriesArr);

        //     return response()->json(['message' => 'All countries added successfully']);
        //     return response()->json(['message' => 'All states added successfully']);
        // } catch (\Exception $exception) {
        //     return response()->json(['error' => $exception->getMessage()], 500);
        // }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Country  $country
     * @return \Illuminate\Http\Response
     */
    public function show(Country $country)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Country  $country
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            $country = Country::whereId($id)->first();

            return response()->json($country, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Country  $country
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            DB::beginTransaction();

            $country = Country::findOrFail($id);

            $country->name = $request->name;
            $country->iso_2 = $request->iso_2;
            $country->iso_3 = $request->iso_3;

            $country->save();

            DB::commit();
            return response()->json(['message' => 'Country updated successfully'], 200);
        } catch (\Exception $exception) {
            DB::rollback();
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Country  $country
     * @return \Illuminate\Http\Response
     */
    public function destroy(Country $country)
    {
        //
    }

    public function checkName(Request $request)
    {
        if ($request->name) {
            $names = Country::where('name', $request->name)->count();
            if ($names > 0)
                return 1;
            if ($names == 0)
                return 0;
        }
    }

    //get form data
    public function getFormData()
    {
        try {
            $obj = new stdClass();
            $obj->allCountries = Country::select('id', 'name')->where('is_active', 1)->get();

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function updateIsActive(Request $request, $countryId)
    {
        try {
            Country::whereId($countryId)->update([
                'is_active' => $request->status
            ]);

            return response()->json(['message' => 'Country status updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
}
