<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Models\Admin\Cms;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class CmsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $cms = Cms::all();

        return view('admin.cms.index', [
            'cms' => $cms
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            DB::beginTransaction();

            $cms = new Cms();

            $cms->user_id = Auth::id();
            $cms->page_name = $request->page_name;
            $cms->page_description = $request->page_description;

            $cms->save();

            $pageImage = null;
            $bannerImage = null;

            if ($request->file('page_image')) {
                $pageImage =  $cms->id . '_page_image.' . pathinfo($request->file('page_image')
                ->getClientOriginalName(), PATHINFO_EXTENSION);
                $request->file('page_image')->storeAs('cms_images', $pageImage, 'public');
            }

            if ($request->file('banner_image')) {
                $bannerImage =  $cms->id . '_banner_image.' . pathinfo($request->file('banner_image')
                ->getClientOriginalName(), PATHINFO_EXTENSION);
                $request->file('banner_image')->storeAs('cms_images', $bannerImage, 'public');
            }

            Cms::where('id', $cms->id)->update([
                'page_image' =>  $pageImage,
                'banner_image' =>  $bannerImage,
            ]);

            DB::commit();
            return response()->json(['message' => 'CMS added successfully'], 201);
        } catch (\Exception $exception) {
            DB::rollback();
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Cms  $cms
     * @return \Illuminate\Http\Response
     */
    public function show(Cms $cms)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Cms  $cms
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            // Cms
            $cms = Cms::whereId($id)->first();

            return response()->json($cms, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Cms  $cms
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            DB::beginTransaction();

            $cms = Cms::findOrFail($id);

            $cms->page_name = $request->page_name;
            $cms->page_description = $request->page_description;

            $cms->save();

            $pageImage = $request->file('page_image');
            $bannerImage = $request->file('banner_image');

            if ($request->file('page_image')) {
                $pageImage =  $cms->id . '_page_image.' . pathinfo($request->file('page_image')
                    ->getClientOriginalName(), PATHINFO_EXTENSION);
                $request->file('page_image')->storeAs('cms_images', $pageImage, 'public');
            }

            if ($request->file('banner_image')) {
                $bannerImage =  $cms->id . '_banner_image.' . pathinfo($request->file('banner_image')
                ->getClientOriginalName(), PATHINFO_EXTENSION);
                $request->file('banner_image')->storeAs('cms_images', $bannerImage, 'public');
            }

            Cms::where('id', $cms->id)->update([
                'page_image' =>  $pageImage,
                'banner_image' =>  $bannerImage,
            ]);

            DB::commit();
            return response()->json(['message' => 'CMS updated successfully'], 200);
        } catch (\Exception $exception) {
            DB::rollback();
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Cms  $cms
     * @return \Illuminate\Http\Response
     */
    public function destroy(Cms $cms)
    {
        //
    }

    public function updateIsActive(Request $request, $id)
    {
        try {
            Cms::whereId($id)->update([
                'is_active' => $request->status
            ]);

            return response()->json(['message' => 'CMS status updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
}
