<?php

namespace App\Http\Controllers\Admin\Cities;

use stdClass;
use App\Models\Admin\City;
use App\Models\Admin\State;
use Illuminate\Http\Request;
use App\Models\Admin\Vehicle;
use App\Models\Admin\ZipCode;
use PhpParser\Node\Expr\New_;
use App\Models\Admin\Services;
use App\Models\Admin\OtherCharges;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\Admin\CitiesServicesSettings;
use App\Models\Admin\ScheduleService;
use App\Models\Admin\TravellerTypes;
use Illuminate\Support\Facades\Auth;
use Illuminate\Database\Eloquent\Model;
use App\Models\Admin\TimelyAdditionalCharges;

class CitiesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        return view('admin.managements.cities.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {

            $city = new City();
            $city->name = $request->name;
            $city->state_id = $request->state_id;
            $city->save();

            return response()->json(['message' => 'City save successfully'], 201);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            $obj = new stdClass();

            $city = City::with('state.country')->findOrFail($id);

            $obj->city = $city;

            return response()->json($obj);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // dd($request->all(), $id);
        try {
            $city = City::findOrFail($id);
            $city->name = $request->name;
            $city->state_id = $request->state_id;

            $city->save();

            return response()->json(['message' => 'City updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function getStatesData($countryId)
    {
        try {
            $data = State::select('id', 'name', 'country_id', 'is_active', 'is_reserved')
                ->with(['country' => function ($q) {
                    $q->select('id', 'name')->where('is_active', 1);
                }])->where('country_id', $countryId)->orderBy('name')->where('is_active', 1)->get();

            return response()->json($data, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function getData($stateId)
    {
        try {

            // $data = DB::connection('company')->table('cities')
            //     ->leftJoin('services_vehicles', 'cities.id', '=', 'services_vehicles.city_id')
            //     ->leftJoin('states', 'states.id', '=', 'cities.state_id')
            //     ->select(
            //         'cities.id as city_id',
            //         'cities.name as city_name',
            //         'cities.is_active as city_is_active',
            //         'cities.is_reserved as city_is_reserved',
            //         'states.id as state_id',
            //         'states.name as state_name',
            //         'services_vehicles.id as service_vehicle_id',
            //         'services_vehicles.city_id as service_vehicle_city_id',
            //         'services_vehicles.is_schedule as service_is_schedule'
            //     )
            //     ->where('cities.state_id', $stateId)
            //     ->where('cities.is_active', 1)
            //     ->orderby('cities.name', 'ASC')
            //     ->get();



            $data = City::select('id', 'name', 'state_id', 'is_active', 'is_reserved', 'services', 'schedule_services')
                ->with(['state' => function ($q) {
                    $q->select('id', 'name');
                }])
                ->where('state_id', $stateId)
                ->orderby('name', 'ASC')
               ->get();

            return response()->json($data, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    // Check name
    public function checkName(Request $request)
    {
        try {
            if (City::where('name',$request->name)->where('state_id', $request->state_id)->exists()) {
                return response()->json(['isAvailable' => false]);
            } else {
                return response()->json(['isAvailable' => true]);
            }
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getFormData()
    {
        try {
            $obj = new stdClass();
            $obj->allStates = State::select('id', 'name')->where('is_active', 1)->get();

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function updateIsActive(Request $request, $id)
    {
        // dd($request->status, $id);
        try {
            City::whereId($id)->update([
                'is_active' => $request->status
            ]);

            return response()->json(['message' => 'City status updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function updateIsReserved(Request $request, $id)
    {
        try {
            City::whereId($id)->update([
                'is_reserved' => $request->status
            ]);

            return response()->json(['message' => 'City Reservation status updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    //get form data
    public function getServiceData(Request $request)
    {
        try {
            $obj = new stdClass();

            $obj->allVehicleTypes = Vehicle::select('id', 'vehicles_type', 'passengers_capacity', 'luggage_capacity', 'is_shared',  'is_schedule')
                ->where('is_active', 1)
                // ->where('is_schedule', $request->is_schedule)
                ->get();
            $obj->allServices = Services::select('id', 'service_name')->where('is_active', 1)->get();
            $obj->allOtherCharges = OtherCharges::select('id', 'name', 'operator', 'is_percentage')->where('is_active', 1)->get();
            $obj->allTimelyCharges = TimelyAdditionalCharges::select('id', 'time_in', 'time_out', 'price', 'operator' ,'is_percentage')->where('is_active', 1)->get();
            $obj->allTravellerTypes = TravellerTypes::select('id', 'name', 'count')->where('is_active', 1)->get();
            $obj->allZipCodes = ZipCode::select('id', 'zip_code')->where('city_id', $request->cityId)->where('is_active', 1)->get();

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getAdditionalServices()
    {
        try {
            $obj = new stdClass();

            $obj->allOtherCharges = OtherCharges::select('id', 'name', 'operator', 'is_percentage')->where('is_active', 1)->get();
            $obj->allTimelyCharges = TimelyAdditionalCharges::select('id', 'time_in', 'time_out', 'price', 'operator' ,'is_percentage')->where('is_active', 1)->get();
            $obj->allTravellerTypes = TravellerTypes::select('id', 'name', 'count')->where('is_active', 1)->get();
            $obj->allVehicleTypes = Vehicle::select('id', 'vehicles_type', 'passengers_capacity', 'luggage_capacity','is_schedule', 'is_shared' )->where('is_active', 1)->get();

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function getAdditionalServiceData(Request $request)
    {
        try {
            // dd('here');
            $obj = new stdClass();

            $obj->allOtherCharges = OtherCharges::select('id', 'name', 'operator', 'is_percentage')->where('is_active', 1)->orderBy('name', 'asc')->get();
            $obj->allTimelyCharges = TimelyAdditionalCharges::select('id', 'time_in', 'time_out', 'price', 'operator' ,'is_percentage')->where('is_active', 1)->get();
            $obj->allTravellerTypes = TravellerTypes::select('id', 'name', 'count')->where('is_active', 1)->get();
            $obj->allVehicleTypes = Vehicle::select('id', 'vehicles_type', 'passengers_capacity','luggage_capacity', 'is_shared', 'is_schedule' )->where('is_active', 1)->get();
            $obj->allZipCodes = ZipCode::select('id', 'zip_code')->where('city_id', $request->cityId)->where('is_active', 1)->get();
            // dd($obj->allZipCodes);

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function getExportedData(Request $request){
        try {
            $stateId = $request->stateID;
            $cityNames = $request->city_name;

            // Ensure that 'city_name' is an array
            if (!is_array($cityNames)) {
                return response()->json(['message' => 'Invalid city name data format'], 400);
            }

            foreach ($cityNames as $cityName) {

                $existingRecord = City::where('state_id', $stateId)
                                ->where('name', $cityName)
                                ->first();

                if(!$existingRecord){
                    $city = new City();
                    $city->state_id = $stateId;
                    $city->name = $cityName;
                    $city->save();
                }

            }

            return response()->json(['message' => 'Cities stored successfully'], 200);
        } catch (\Exception $e) {
            return response()->json(['message' => 'Error storing data: ' . $e->getMessage()], 500);
        }

    }
    public function applySettingsCities(Request $request){
        try {
            DB::beginTransaction();
            $cityId = $request['cityId'];
            $applyCityIds = $request['applyCityIds'];


            $cityServiceSettings= CitiesServicesSettings::where('city_id',$cityId)->get();
            foreach($cityServiceSettings as $settings){
                foreach ($applyCityIds as $applyCityId) {
                    CitiesServicesSettings::updateOrCreate(
                        ['city_id' => $applyCityId,'service_id' => $settings->service_id],
                        ['service_id' => $settings->service_id,'services' => $settings->services]
                    );
                }
            }

            // $scheduleServiceSettings  = ScheduleService::where('city_id',$cityId)->get();

            // foreach ($applyCityIds as $applyCityId) {
            //     foreach($scheduleServiceSettings  as $scheduleService){
            //         $scheduleData = $scheduleService->toArray();
            //         unset($scheduleData['id']); // Remove 'id' to avoid conflicts on create
            //         // Update the city_id for the new entry
            //         $scheduleData['city_id'] = $applyCityId;
            //         // Use updateOrCreate to either update or create the record
            //         ScheduleService::updateOrCreate(
            //             ['city_id' => $applyCityId],
            //             $scheduleData
            //         );
            //     }
            // }
            DB::commit();
            return response()->json(['message' => 'Settings applied successfully'], 200);

        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json(['error' => 'Error importing customers', 'message' => $e->getMessage()], 500);
        }


    }
}
