<?php

namespace App\Http\Controllers\Admin\Auth;

use Carbon\Carbon;
use App\Models\Admin\User;
use Illuminate\Support\Str;
use App\Models\Admin\Driver;
use Illuminate\Http\Request;
use App\Models\Admin\Customer;
use App\Models\Admin\UserGroup;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Google\Service\Monitoring\Custom;
use Illuminate\Support\Facades\Password;
use Illuminate\Auth\Events\PasswordReset;
use Illuminate\Support\Facades\Validator;

class AdminAuthController extends Controller
{
    public function loginPage(){

        return view('admin.auth.login');
    }
    public function customerForgetPage(){

        return view('customer.auth.email-authenticate',[
            'routeFor' => 'web'
        ]);
    }
    public function iFrameCustomerForgetPage(){

        return view('customer.auth.email-authenticate',[
            'routeFor' => 'api'
        ]);
    }


    public function login(Request $request){

        $this->validate($request, [
            'email' => 'required|string',
            'password' => 'required|string',
        ]);

        // dd($request->all());

        if (Auth::attempt(['email' => $request['email'], 'password' => $request['password']]))
        {
            // dd($request->all());
            $user =  Auth::user();

            if ($user->is_active == 1 && $user->role_id != 2) {
                $user->last_login = Carbon::now();
                $user->last_ip = $request->getClientIp();
                $user->save();


                // dd($userPermission);
                session(['user' => $user]);

                return redirect()->route('admin-dashboard');
            }
            else{
                return redirect()->back()->withErrors(['error' => 'You are not authorized to login.']);
            }
        }
        return redirect()->back()->withErrors(['error' => 'Email or Password is wrong']);
    }

    public function showDriverLoginForm()
    {
        if (auth()->guard('driver')->check()) {
            return redirect()->route('driver.dashboard');
        }
        return view('driver.auth.driver', ['url' => 'login', 'guard' => 'driver']);
    }

    public function driverLogin(Request $request){
        $this->validate($request, [
            'email' => 'required|string',
            'password' => 'required|string',
        ]);

        $driver = Driver::where('email', $request->email)->first();

        if ($driver && Hash::check($request->password, $driver->password)) {
            // The user is authenticated
            Auth::guard('driver')->login($driver,$remember = true);
            return response()->json(['success' => true]);
        }

        // Authentication failed
        return response()->json(['success' => false, 'error' => 'Email or Password is wrong']);
    }

    public function showCustomerLoginForm()
    {
        return view('customer.auth.customer');
        // return view('customer.auth.customer', ['url' => 'login', 'guard' => 'customer']);
    }

    public function customerLogin(Request $request){
        $this->validate($request, [
            'email' => 'required|email',
            'password' => 'required|string',
        ]);

        $columns = ['id', 'first_name', 'last_name', 'address', 'billing_address', 'notes', 'pay_type_id','card_type', 'cc_expiry', 'cc_status', DB::raw("RIGHT(cc_number, 4) AS cc_number"), 'phone_number', 'mobile_number', 'email', 'is_active','customer_type','password'];
        $customer = Customer::select($columns)->where('email', $request->email)->where('is_active',1)->first();
        if ($customer && Hash::check($request->password, $customer->password)) {
            // Authentication succeeded
            if($request->is('api/*')){
                $token = $customer->createToken('Api Token for the customer',['reservation','customers'])->accessToken;
                return response()->json(['success' => true,'token' => $token]);
            }else{
                Auth::guard('customer')->login($customer);
                return response()->json(['success' => true]);
            }
        }

        // Authentication failed
        return response()->json(['success' => false, 'error' => 'Email or Password is wrong']);
    }
    public function AuthenticatedCustomer(){
        return response()->json(['customer' => Auth::user()]);
    }
    public function logout(){
        Auth::logout();
        return redirect()->route('admin-login-page')->with('message', 'Logout Successfully');
    }

    public function resetCustomerPassword(Request $request){

        $validator = Validator::make($request->all(), [
            'token' => 'required',
            'email' => 'required|email',
            'password' => 'required|min:8|confirmed',
        ]);
        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }
        $status = Password::reset(
            $request->only('email', 'password', 'password_confirmation', 'token'),
            function ($user, $password) {
                $user->forceFill([
                    'password' => Hash::make($password),
                    'readable_password' => $password
                ])->setRememberToken(Str::random(60));

                $user->save();

                event(new PasswordReset($user));
            }
        );
        if ($status === Password::PASSWORD_RESET) {
            return back()->with('status', __('Password has been reset Successfully!'));
        } elseif ($status === Password::INVALID_TOKEN) {
            // Check if the token was already used
            $user = User::where('email', $request->email)->first();
            if ($user && $user->password_reset_at !== null) {
                return back()->withErrors(['email' => __('This token has already been used.')]);
            } else {
                return back()->withErrors(['email' => __('The provided token is invalid.')]);
            }
        } else {
            return back()->withErrors(['email' => __($status)]);
        }
    }

}
