<?php

namespace App\Http\Controllers\admin\Airports;

use stdClass;
use App\Models\Admin\City;
use App\Models\Admin\State;
use Illuminate\Http\Request;
use App\Models\Admin\Airport;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class AirportsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.managements.airports.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // dd($request->all());
        try {
            $airport = new Airport();

            //$state = State::select('id')->where('name', $stateName)->pluck('id')->first();

            // $city = City::select('id','state_id', 'name', 'is_active')
            // ->where('name', $request->location['city'])
            // ->orWhere('name', $request->location['county'])
            // ->first();

            $addressLoc = $request->input('location');
            $city = City::select('id', 'state_id', 'name', 'is_active')
            ->where('name', $addressLoc['city'])
            ->whereHas('state', function ($query) use ($addressLoc) {
                $query->where('name', $addressLoc['state']);
            })
            ->first();

             $airport->state_id = $city->state_id;
             $airport->city_id = $city->id;
             $airport->airport_location = $request->location;
             $airport->name = $request->name;
             $airport->code = $request->code;

             $airport->save();

            return response()->json(['message' => 'Airport saved successfully'], 201);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            $obj = new stdClass();

            $airport = Airport::with('city.state.country')->findOrFail($id);

            $obj->airport = $airport;

            return response()->json($obj);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            $airport = Airport::findOrFail($id);

            $addressLoc = $request->input('location');

            $city = City::select('id', 'state_id', 'name', 'is_active')
            ->where('name', $addressLoc['city'])
            ->whereHas('state', function ($query) use ($addressLoc) {
                $query->where('name', $addressLoc['state']);
            })
            ->first();



            $airport->state_id = $city->state_id;
            $airport->city_id = $city->id;
            $airport->airport_location = $request->location;
            $airport->name = $request->name;
            $airport->code = $request->code;

            $airport->save();

            return response()->json(['message' => 'Airport updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        // dd($id);
        $airport= Airport::findOrFail($id);
        $airport->delete();

        return response()->json(['message' => 'Airport deleted successfully']);
    }

    public function getAll(){

        try {
            $data = Airport::select( 'name', 'airport_location')->where('is_active', 1)
                ->orderBy('name', 'asc')
                ->get();
            return response()->json($data, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }



    }

    public function getData(Request $request)
    {
        try {
            $obj = new stdClass();

            $data = Airport::with(['state', 'city' => function ($query) {
                $query->select('id', 'name');
            }])
            ->select('id', 'name', 'airport_location', 'code', 'state_id', 'city_id', 'is_active');

            // Check for 'city_id' in the request and it's not empty
            if (!empty($request['city_id'])) {
                $data->where('city_id', $request['city_id']);
            }
            // Check for 'state_id' in the request and it's not empty
            else if (!empty($request['state_id'])) {
                $data->where('state_id', $request['state_id']);
            }
            // Check for 'country_id' in the request and it's not empty
            else if (!empty($request['country_id'])) {
                // Use a subquery for selecting state IDs
                $data->whereIn('state_id', function ($query) use ($request) {
                    $query->select('id')
                        ->from('states')
                        ->where('country_id', $request['country_id']);
                });
            }

            $data = $data->orderBy('name', 'ASC')->get();

            $obj->data = $data;

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    // Check name
    public function checkInputField(Request $request)
    {
        try {
            if (Airport::whereName($request->name)->exists()) {
                return response()->json(['isAvailable' => false]);
            } else {
                return response()->json(['isAvailable' => true]);
            }
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    // get form data
    public function getFormData()
    {
        try {
            $obj = new stdClass();
            $obj->allStates = State::select('id', 'name')->where('is_active', 1)->get();
            $obj->allCities = City::select('id', 'name')->whereIn('state_id', [23, 34])->where('is_active', 1)->get();

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function updateIsActive(Request $request, $id)
    {
        try {
            Airport::whereId($id)->update([
                'is_active' => $request->status
            ]);

            return response()->json(['message' => 'Airport status updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getExportedData(Request $request)
    {
        try {
            $cityId = $request->cityID;
            $stateId = $request->stateID;
            $airports = $request->airports;

            // Ensure that 'airports' is an array
            if (!is_array($airports)) {
                return response()->json(['message' => 'Invalid Airport Data'], 400);
            }

            foreach ($airports as $airportData) {
                $airportName = $airportData['AirportName'];
                $airportCode = $airportData['AirportCode'];

                $existingRecord = Airport::where('city_id', $cityId)
                    ->where('state_id', $stateId)
                    ->where('name', $airportName) // Check if an airport with the same name already exists
                    ->first();

                if (!$existingRecord) {
                    $airport_data = new Airport();

                    $airport_data->state_id = $stateId;
                    $airport_data->city_id = $cityId;
                    $airport_data->name = $airportName;
                    $airport_data->code = $airportCode;

                    $airport_data->save();
                }
            }

            return response()->json(['message' => 'Data stored successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
}
    }

}
