<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Models\Admin\Airline;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class AirlineController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

           return view('admin.airlines.index');
    }

    public function getAll()
    {

        try {
            $data = Airline::select('id', 'airline_name')->where('is_active', 1)
            ->orderBy('airline_name', 'asc')
                ->get();
            return response()->json($data, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            DB::beginTransaction();

            $airline = new Airline();

            $airline->user_id = Auth::id();
            $airline->airline_name = $request->airline_name;
            $airline->is_active = 1;

            $airline->save();
            DB::commit();
            return response()->json(['message' => 'Airline added successfully','airline' => $airline], 201);
        } catch (\Exception $exception) {
            DB::rollback();
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Airline  $airline
     * @return \Illuminate\Http\Response
     */
    public function show(Airline $airline)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Airline  $airline
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            // airline
            $airline = Airline::whereId($id)->first();

            return response()->json($airline, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Airline  $airline
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            DB::beginTransaction();

            $airline = Airline::findOrFail($id);

            $airline->airline_name = $request->airline_name;

            $airline->save();

            DB::commit();
            return response()->json(['message' => 'Airline updated successfully','airline' => $airline], 200);
        } catch (\Exception $exception) {
            DB::rollback();
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Airline  $airline
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        // dd($id);
        $airline = Airline::findOrFail($id);
        $airline->delete();

        return response()->json(['message' => 'Airline Deleted Successfully']);
    }
    public function updateIsActive(Request $request, $id)
    {
        try {
            Airline::whereId($id)->update([
                'is_active' => $request->status
            ]);

            return response()->json(['message' => 'Airline status updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getAirlineData(){
        $airlines = Airline::select('id','airline_name','is_active')
        ->orderBy('airline_name', 'asc')
        ->get();
        return response()->json($airlines);
    }

    public function importData(Request $request){
        // dd($request->all());
        try {
            DB::beginTransaction();
            $insertData = [];
            foreach($request['Name'] as $name){
                $airlineData = [
                    'airline_name' => $name
                ];
                $insertData[] = $airlineData;
            }

            if (!empty($insertData)) {
                Airline::insert($insertData);
            }
            DB::commit();
            return response()->json(['message' => 'Airline Data Imported Successfully'], 200);
        } catch (\Throwable $th) {
            //throw $th;
        }

    }
}
