<?php

namespace App\Http\Controllers\Admin;

use stdClass;
use App\Models\Admin\User;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use App\Models\Admin\UserGroup;
use App\Models\Admin\ExpensesHead;
use App\Http\Controllers\Controller;
use App\Models\Admin\ExpenseDetails;
use Illuminate\Support\Facades\Auth;

class AccountingController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.accounting.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            $expense_detail = new ExpenseDetails();

            $user = User::select('id', 'role_id')->where('id', Auth::id())->first();

            $expense_detail->user_id = $user->id;
            $expense_detail->user_group_id = $user->role_id;
            $expense_detail->expense_id = $request->expense_id;
            $expense_detail->expense_details = $request->expense_details;
            $expense_detail->expense_date = Carbon::today()->toDateString();
            $expense_detail->amount = $request->amount;

            $expense_detail->save();

            return response()->json(['message' => 'Expense added successfully'], 201);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            $obj = new stdClass();

            $expense_detail = ExpenseDetails::findOrFail($id);

            $obj->expense_detail = $expense_detail;

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            $expense_detail = ExpenseDetails::findOrFail($id);

            $expense_detail->expense_id = $request->expense_id;
            $expense_detail->amount = $request->amount;
            $expense_detail->expense_details = $request->expense_details;
            $expense_detail->expense_date = $request->expense_date;

            $expense_detail->save();

            return response()->json(['message' => 'Expense updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function getAllAccountsByDate($date)
    {
        $obj = new stdClass();

        $obj->allExpenseDetails = ExpenseDetails::whereDate('expense_date', '=', $date)->where('is_active', 1)->get();

        $obj->allExpenseHeads = ExpensesHead::select('id', 'name')->where('is_active', 1)->get();
        $obj->allUserGroups = UserGroup::select('id', 'name')->where('is_active', 1)->get();

        return response()->json($obj, 200);
    }

    public function getFormData()
    {

        $obj = new stdClass();

        $obj->allExpenseHeads = ExpensesHead::select('id', 'name')
        ->where('is_active', 1)
        ->orderByRaw("CASE WHEN name REGEXP '^[0-9]' THEN 2 ELSE 1 END, name ASC")
        ->get();


        return response()->json($obj, 200);
    }


}
